/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.state.ContainerMock;
import be.seeseemelk.mockbukkit.inventory.FurnaceInventoryMock;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFurnaceMock
extends ContainerMock
implements Furnace {
    private short burnTime;
    private short cookTime;
    private int cookTimeTotal;
    private double cookSpeedMultiplier = 1.0;

    protected AbstractFurnaceMock(@NotNull Material material) {
        super(material);
        this.checkType(material, Material.SMOKER, Material.FURNACE, Material.BLAST_FURNACE);
    }

    protected AbstractFurnaceMock(@NotNull Block block) {
        super(block);
        this.checkType(block, Material.SMOKER, Material.FURNACE, Material.BLAST_FURNACE);
    }

    protected AbstractFurnaceMock(@NotNull AbstractFurnaceMock state) {
        super(state);
        this.burnTime = state.burnTime;
        this.cookTime = state.cookTime;
        this.cookTimeTotal = state.cookTimeTotal;
        this.cookSpeedMultiplier = state.cookSpeedMultiplier;
    }

    @Override
    @NotNull
    protected FurnaceInventoryMock createInventory() {
        return new FurnaceInventoryMock((InventoryHolder)this);
    }

    public short getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(short burnTime) {
        this.burnTime = burnTime;
    }

    public short getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(short cookTime) {
        this.cookTime = cookTime;
    }

    public int getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    public void setCookTimeTotal(int cookTimeTotal) {
        this.cookTimeTotal = cookTimeTotal;
    }

    @NotNull
    public Map<CookingRecipe<?>, Integer> getRecipesUsed() {
        throw new UnimplementedOperationException();
    }

    public double getCookSpeedMultiplier() {
        return this.cookSpeedMultiplier;
    }

    public void setCookSpeedMultiplier(double multiplier) {
        Preconditions.checkArgument((multiplier >= 0.0 ? 1 : 0) != 0, (Object)"Furnace speed multiplier cannot be negative");
        Preconditions.checkArgument((multiplier <= 200.0 ? 1 : 0) != 0, (Object)"Furnace speed multiplier cannot more than 200");
        this.cookSpeedMultiplier = multiplier;
    }

    public int getRecipeUsedCount(@NotNull NamespacedKey furnaceRecipe) {
        throw new UnimplementedOperationException();
    }

    public boolean hasRecipeUsedCount(@NotNull NamespacedKey furnaceRecipe) {
        throw new UnimplementedOperationException();
    }

    public void setRecipeUsedCount(@NotNull CookingRecipe<?> furnaceRecipe, int count) {
        throw new UnimplementedOperationException();
    }

    public void setRecipesUsed(@NotNull Map<CookingRecipe<?>, Integer> recipesUsed) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public FurnaceInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return (FurnaceInventory)super.getInventory();
    }

    @NotNull
    public FurnaceInventory getSnapshotInventory() {
        return (FurnaceInventory)super.getSnapshotInventory();
    }
}

