/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.block.state.ContainerMock;
import be.seeseemelk.mockbukkit.inventory.BrewerInventoryMock;
import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import com.google.common.base.Preconditions;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class BrewingStandMock
extends ContainerMock
implements BrewingStand {
    private int recipeBrewingTime = 400;
    private int brewingTime;
    private int fuelLevel;

    public BrewingStandMock(@NotNull Material material) {
        super(material);
        this.checkType(material, Material.BREWING_STAND);
    }

    protected BrewingStandMock(@NotNull Block block) {
        super(block);
        this.checkType(block, Material.BREWING_STAND);
    }

    protected BrewingStandMock(@NotNull BrewingStandMock state) {
        super(state);
        this.brewingTime = state.brewingTime;
        this.fuelLevel = state.fuelLevel;
    }

    @Override
    @NotNull
    protected InventoryMock createInventory() {
        return new BrewerInventoryMock((InventoryHolder)this);
    }

    @Override
    @NotNull
    public BlockState getSnapshot() {
        return new BrewingStandMock(this);
    }

    public int getBrewingTime() {
        return this.brewingTime;
    }

    public void setBrewingTime(int brewTime) {
        this.brewingTime = brewTime;
    }

    public void setRecipeBrewTime(@Range(from=1L, to=0x7FFFFFFFL) int recipeBrewTime) {
        Preconditions.checkArgument((recipeBrewTime > 0 ? 1 : 0) != 0, (Object)"recipeBrewTime must be positive");
        this.recipeBrewingTime = recipeBrewTime;
    }

    public @Range(from=1L, to=0x7FFFFFFFL) int getRecipeBrewTime() {
        return this.recipeBrewingTime;
    }

    public int getFuelLevel() {
        return this.fuelLevel;
    }

    public void setFuelLevel(int level) {
        this.fuelLevel = level;
    }

    @NotNull
    public BrewerInventory getInventory() {
        return (BrewerInventory)super.getInventory();
    }

    @NotNull
    public BrewerInventory getSnapshotInventory() {
        return (BrewerInventory)super.getSnapshotInventory();
    }
}

