/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.damage;

import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.damage.DamageScaling;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageSourceMock
implements DamageSource {
    private final DamageType damageType;
    private final Entity causingEntity;
    private final Entity directEntity;
    private final Location damageLocation;

    public DamageSourceMock(DamageType damageType, Entity causingEntity, Entity directEntity, Location damageLocation) {
        this.damageType = damageType;
        this.causingEntity = causingEntity;
        this.directEntity = directEntity;
        this.damageLocation = damageLocation;
    }

    @NotNull
    public DamageType getDamageType() {
        return this.damageType;
    }

    @Nullable
    public Entity getCausingEntity() {
        return this.causingEntity;
    }

    @Nullable
    public Entity getDirectEntity() {
        return this.directEntity;
    }

    @Nullable
    public Location getDamageLocation() {
        return this.damageLocation != null ? this.damageLocation.clone() : null;
    }

    @Nullable
    public Location getSourceLocation() {
        if (this.damageLocation != null) {
            return this.getDamageLocation();
        }
        return this.directEntity != null ? this.directEntity.getLocation() : null;
    }

    public boolean isIndirect() {
        return this.causingEntity != this.directEntity;
    }

    public float getFoodExhaustion() {
        return this.damageType.getExhaustion();
    }

    public boolean scalesWithDifficulty() {
        return switch (this.damageType.getDamageScaling()) {
            default -> throw new MatchException(null, null);
            case DamageScaling.NEVER -> false;
            case DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER -> {
                if (this.causingEntity instanceof LivingEntity && !(this.causingEntity instanceof Player)) {
                    yield true;
                }
                yield false;
            }
            case DamageScaling.ALWAYS -> true;
        };
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DamageSource)) {
            return false;
        }
        DamageSource other = (DamageSource)obj;
        return Objects.equals(this.getDamageType(), other.getDamageType()) && Objects.equals(this.getCausingEntity(), other.getCausingEntity()) && Objects.equals(this.getDirectEntity(), other.getDirectEntity()) && Objects.equals(this.getDamageLocation(), other.getDamageLocation());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.damageType.hashCode();
        result = 31 * result + (this.getCausingEntity() != null ? this.getCausingEntity().hashCode() : 0);
        result = 31 * result + (this.getDirectEntity() != null ? this.getDirectEntity().hashCode() : 0);
        result = 31 * result + (this.getDamageLocation() != null ? this.getDamageLocation().hashCode() : 0);
        return result;
    }
}

