/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.damage;

import be.seeseemelk.mockbukkit.damage.DamageEffectMock;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DamageScaling;
import org.bukkit.damage.DamageType;
import org.bukkit.damage.DeathMessageType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class DamageTypeMock
implements DamageType {
    static final String EXHAUSTION_KEY = "exhaustion";
    static final String DEATH_MESSAGE_TYPE_KEY = "deathMessageType";
    static final String SOUND_KEY = "sound";
    static final String DAMAGE_SCALING_KEY = "damageScaling";
    static final String KEY = "key";
    static final String TRANSLATION_KEY = "translationKey";
    private final DamageScaling damageScaling;
    private final DamageEffectMock damageEffect;
    private final NamespacedKey namespacedKey;
    private final DeathMessageType deathMessageType;
    private final float exhaustion;
    private final String translationKey;

    @ApiStatus.Internal
    public static DamageTypeMock from(JsonObject data) {
        Preconditions.checkNotNull((Object)data, (Object)"JsonObject can't be null");
        Preconditions.checkArgument((boolean)data.has(KEY), (Object)"JsonObject does not have a field named 'key'");
        Preconditions.checkArgument((boolean)data.has(DAMAGE_SCALING_KEY), (Object)"JsonObject does not have a field named 'damageScaling'");
        Preconditions.checkArgument((boolean)data.has(SOUND_KEY), (Object)"JsonObject does not have a field named 'sound'");
        Preconditions.checkArgument((boolean)data.has(DEATH_MESSAGE_TYPE_KEY), (Object)"JsonObject does not have a field named 'deathMessageType'");
        Preconditions.checkArgument((boolean)data.has(EXHAUSTION_KEY), (Object)"JsonObject does not have a field named 'exhaustion'");
        String keyValue = data.get(KEY).getAsString();
        String damageScalingValue = data.get(DAMAGE_SCALING_KEY).getAsString();
        String soundValue = data.get(SOUND_KEY).getAsString();
        String deathMessageTypeValue = data.get(DEATH_MESSAGE_TYPE_KEY).getAsString();
        String translationKey = data.get(TRANSLATION_KEY).getAsString();
        float exhaustion = data.get(EXHAUSTION_KEY).getAsFloat();
        NamespacedKey key = NamespacedKey.fromString((String)keyValue);
        DamageScaling damageScaling = DamageScaling.valueOf((String)damageScalingValue);
        Sound sound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)soundValue));
        DamageEffectMock damageEffect = new DamageEffectMock(sound);
        DeathMessageType deathMessageType = DeathMessageType.valueOf((String)deathMessageTypeValue);
        return new DamageTypeMock(damageScaling, damageEffect, key, deathMessageType, exhaustion, translationKey);
    }

    @ApiStatus.Internal
    public DamageTypeMock(@NotNull DamageScaling damageScaling, @NotNull DamageEffectMock damageEffect, @NotNull NamespacedKey namespacedKey, @NotNull DeathMessageType deathMessageType, float exhaustion, @NotNull String translationKey) {
        Preconditions.checkNotNull((Object)damageScaling, (Object)"DamageScaling cannot be null");
        Preconditions.checkNotNull((Object)damageEffect, (Object)"DamageEffectMock cannot be null");
        Preconditions.checkNotNull((Object)namespacedKey, (Object)"NamespacedKey cannot be null");
        Preconditions.checkNotNull((Object)deathMessageType, (Object)"DeathMessageType cannot be null");
        Preconditions.checkNotNull((Object)translationKey, (Object)"Translation key cannot be null");
        this.damageScaling = damageScaling;
        this.damageEffect = damageEffect;
        this.namespacedKey = namespacedKey;
        this.deathMessageType = deathMessageType;
        this.exhaustion = exhaustion;
        this.translationKey = translationKey;
    }

    @Deprecated(forRemoval=true, since="v3.76.1")
    public DamageTypeMock(JsonObject data) {
        this.damageScaling = DamageScaling.valueOf((String)data.get(DAMAGE_SCALING_KEY).getAsString());
        Sound sound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)data.get(SOUND_KEY).getAsString()));
        this.damageEffect = new DamageEffectMock(sound);
        this.namespacedKey = NamespacedKey.fromString((String)data.get(KEY).getAsString());
        this.deathMessageType = DeathMessageType.valueOf((String)data.get(DEATH_MESSAGE_TYPE_KEY).getAsString());
        this.exhaustion = data.get(EXHAUSTION_KEY).getAsFloat();
        this.translationKey = data.get(TRANSLATION_KEY).getAsString();
    }

    @NotNull
    public String getTranslationKey() {
        return this.translationKey;
    }

    @NotNull
    public DamageScaling getDamageScaling() {
        return this.damageScaling;
    }

    @NotNull
    public DamageEffect getDamageEffect() {
        return this.damageEffect;
    }

    @NotNull
    public DeathMessageType getDeathMessageType() {
        return this.deathMessageType;
    }

    public float getExhaustion() {
        return this.exhaustion;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.namespacedKey;
    }
}

