/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.enchantments;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.papermc.paper.enchantments.EnchantmentRarity;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantmentMock
extends Enchantment {
    private static final String LEVEL = "level";
    private static final String COST = "cost";
    private static final String TREASURE_KEY = "treasure";
    private static final String CURSED_KEY = "cursed";
    private static final String MAX_LEVEL_KEY = "maxLevel";
    private static final String START_LEVEL_KEY = "startLevel";
    private static final String NAME_KEY = "name";
    private static final String DISPLAY_NAMES_KEY = "displayNames";
    private static final String MIN_MODIFIED_COSTS_KEY = "minModifiedCosts";
    private static final String MAX_MODIFIED_COSTS_KEY = "maxModifiedCosts";
    private static final String TRADEABLE_KEY = "tradeable";
    private static final String DISCOVERABLE_KEY = "discoverable";
    private static final String CONFLICTS_KEY = "conflicts";
    private static final String ENCHANTABLE_KEY = "enchantable";
    private static final String TRANSLATION_KEY = "translationKey";
    private static final String ANVIL_COST_KEY = "anvilCost";
    private static final String KEY = "key";
    private static final String ENCHANTABLES_KEY = "enchantables";
    @NotNull
    private final String name;
    private final NamespacedKey namespacedKey;
    private final boolean tradeable;
    private final boolean discoverable;
    private final Set<NamespacedKey> conflicts;
    private final Set<NamespacedKey> enchantables;
    private boolean treasure;
    private final Component[] displayNames;
    private final int[] maxModifiedCosts;
    private boolean cursed;
    private final int[] minModifiedCosts;
    private int maxLevel;
    private int startLevel;
    private final String translationKey;
    private final int anvilCost;

    public EnchantmentMock(NamespacedKey namespacedKey, boolean treasure, boolean cursed, int maxLevel, int startLevel, String name, Component[] displayNames, int[] minModifiedCost, int[] maxModifiedCost, boolean tradeable, boolean discoverable, Set<NamespacedKey> conflicts, Set<NamespacedKey> enchantables, String translationKey, int anvilCost) {
        this.namespacedKey = namespacedKey;
        this.treasure = treasure;
        this.cursed = cursed;
        this.maxLevel = maxLevel;
        this.startLevel = startLevel;
        this.name = name;
        this.displayNames = displayNames;
        this.minModifiedCosts = minModifiedCost;
        this.maxModifiedCosts = maxModifiedCost;
        this.tradeable = tradeable;
        this.discoverable = discoverable;
        this.conflicts = conflicts;
        this.enchantables = enchantables;
        this.translationKey = translationKey;
        this.anvilCost = anvilCost;
    }

    @Deprecated(forRemoval=true, since="v3.82.0")
    public EnchantmentMock(JsonObject data) {
        this.namespacedKey = NamespacedKey.fromString((String)data.get(KEY).getAsString());
        this.treasure = data.get(TREASURE_KEY).getAsBoolean();
        this.cursed = data.get(CURSED_KEY).getAsBoolean();
        this.maxLevel = data.get(MAX_LEVEL_KEY).getAsInt();
        this.startLevel = data.get(START_LEVEL_KEY).getAsInt();
        this.name = data.get(NAME_KEY).getAsString();
        this.displayNames = EnchantmentMock.getDisplayNames(data.get(DISPLAY_NAMES_KEY).getAsJsonArray(), this.maxLevel);
        this.minModifiedCosts = EnchantmentMock.getModifiedCosts(data.get(MIN_MODIFIED_COSTS_KEY).getAsJsonArray(), this.maxLevel);
        this.maxModifiedCosts = EnchantmentMock.getModifiedCosts(data.get(MAX_MODIFIED_COSTS_KEY).getAsJsonArray(), this.maxLevel);
        this.tradeable = data.get(TRADEABLE_KEY).getAsBoolean();
        this.discoverable = data.get(DISCOVERABLE_KEY).getAsBoolean();
        this.conflicts = EnchantmentMock.getConflicts(data.get(CONFLICTS_KEY).getAsJsonArray());
        this.enchantables = EnchantmentMock.getEnchantables(data.get(ENCHANTABLE_KEY).getAsJsonArray());
        this.translationKey = data.get(TRANSLATION_KEY).getAsString();
        this.anvilCost = data.get(ANVIL_COST_KEY).getAsInt();
    }

    @NotNull
    public Component displayName(int level) {
        return this.displayNames[level - 1];
    }

    public boolean isTradeable() {
        return this.tradeable;
    }

    public boolean isDiscoverable() {
        return this.discoverable;
    }

    public int getMaxModifiedCost(int level) {
        return this.maxModifiedCosts[level - 1];
    }

    public int getAnvilCost() {
        return this.anvilCost;
    }

    public int getMinModifiedCost(int level) {
        return this.minModifiedCosts[level - 1];
    }

    @Deprecated(forRemoval=true, since="1.20.5")
    @NotNull
    public EnchantmentRarity getRarity() {
        throw new UnsupportedOperationException("Enchantments don't have a rarity anymore in 1.20.5+.");
    }

    @Deprecated(forRemoval=true, since="1.20.5")
    public float getDamageIncrease(int level, @NotNull EntityCategory entityCategory) {
        throw new UnimplementedOperationException();
    }

    @Deprecated(forRemoval=true, since="1.21")
    public float getDamageIncrease(int level, @NotNull EntityType entityType) {
        throw new UnimplementedOperationException();
    }

    @Deprecated(forRemoval=true, since="1.21")
    @NotNull
    public Set<EquipmentSlot> getActiveSlots() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<EquipmentSlotGroup> getActiveSlotGroups() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Component description() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public RegistryKeySet<ItemType> getSupportedItems() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public RegistryKeySet<ItemType> getPrimaryItems() {
        throw new UnimplementedOperationException();
    }

    public int getWeight() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public RegistryKeySet<Enchantment> getExclusiveWith() {
        throw new UnimplementedOperationException();
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public String translationKey() {
        return this.translationKey;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    @Deprecated(forRemoval=true, since="1.20.5")
    @NotNull
    public EnchantmentTarget getItemTarget() {
        throw new UnsupportedOperationException("Method no longer applicable. Use Tags instead.");
    }

    @Deprecated(forRemoval=true)
    public void setItemTarget(@NotNull EnchantmentTarget itemTarget) {
        throw new UnsupportedOperationException("Method no longer applicable. Use Tags instead.");
    }

    public boolean isTreasure() {
        return this.treasure;
    }

    public void setTreasure(boolean isTreasure) {
        this.treasure = isTreasure;
    }

    public boolean isCursed() {
        return this.cursed;
    }

    public void setCursed(boolean isCursed) {
        this.cursed = isCursed;
    }

    public boolean conflictsWith(@NotNull Enchantment other) {
        Preconditions.checkArgument((other != null ? 1 : 0) != 0, (Object)"others can't be null");
        return this.conflicts.contains(other.getKey());
    }

    public boolean canEnchantItem(@NotNull ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"Item cannot be null");
        NamespacedKey namespacedKey = item.getType().getKey();
        return this.enchantables.contains(namespacedKey);
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.namespacedKey;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public String getTranslationKey() {
        return this.translationKey.toString();
    }

    @ApiStatus.Internal
    public static EnchantmentMock from(JsonObject data) {
        Preconditions.checkNotNull((Object)data);
        List<String> expectedArguments = List.of(KEY, TREASURE_KEY, CURSED_KEY, MAX_LEVEL_KEY, START_LEVEL_KEY, NAME_KEY, DISPLAY_NAMES_KEY, MIN_MODIFIED_COSTS_KEY, MAX_MODIFIED_COSTS_KEY, TRADEABLE_KEY, DISCOVERABLE_KEY, CONFLICTS_KEY, ENCHANTABLES_KEY);
        expectedArguments.forEach(expectedKey -> Preconditions.checkArgument((boolean)data.has(expectedKey), (Object)("Missing json key: " + expectedKey)));
        NamespacedKey key = NamespacedKey.fromString((String)data.get(KEY).getAsString());
        boolean treasure = data.get(TREASURE_KEY).getAsBoolean();
        boolean cursed = data.get(CURSED_KEY).getAsBoolean();
        int maxLevel = data.get(MAX_LEVEL_KEY).getAsInt();
        int startLevel = data.get(START_LEVEL_KEY).getAsInt();
        String name = data.get(NAME_KEY).getAsString();
        Component[] displayNames = EnchantmentMock.getDisplayNames(data.get(DISPLAY_NAMES_KEY).getAsJsonArray(), maxLevel);
        int[] minModifiedCosts = EnchantmentMock.getModifiedCosts(data.get(MIN_MODIFIED_COSTS_KEY).getAsJsonArray(), maxLevel);
        int[] maxModifiedCosts = EnchantmentMock.getModifiedCosts(data.get(MAX_MODIFIED_COSTS_KEY).getAsJsonArray(), maxLevel);
        boolean tradeable = data.get(TRADEABLE_KEY).getAsBoolean();
        boolean discoverable = data.get(DISCOVERABLE_KEY).getAsBoolean();
        Set<NamespacedKey> conflicts = EnchantmentMock.getConflicts(data.get(CONFLICTS_KEY).getAsJsonArray());
        Set<NamespacedKey> enchantables = EnchantmentMock.getEnchantables(data.get(ENCHANTABLES_KEY).getAsJsonArray());
        String translationKey = data.get(TRANSLATION_KEY).getAsString();
        int anvilCost = data.get(ANVIL_COST_KEY).getAsInt();
        return new EnchantmentMock(key, treasure, cursed, maxLevel, startLevel, name, displayNames, minModifiedCosts, maxModifiedCosts, tradeable, discoverable, conflicts, enchantables, translationKey, anvilCost);
    }

    private static Set<NamespacedKey> getConflicts(JsonArray conflicts) {
        HashSet<NamespacedKey> output = new HashSet<NamespacedKey>();
        for (JsonElement conflict : conflicts) {
            output.add(NamespacedKey.fromString((String)conflict.getAsString()));
        }
        return output;
    }

    private static Set<NamespacedKey> getEnchantables(JsonArray enchantables) {
        HashSet<NamespacedKey> output = new HashSet<NamespacedKey>();
        for (JsonElement enchantable : enchantables) {
            output.add(NamespacedKey.fromString((String)enchantable.getAsString()));
        }
        return output;
    }

    private static Component[] getDisplayNames(JsonArray displayNamesData, int maxLevel) {
        Component[] output = new Component[maxLevel];
        for (JsonElement element : displayNamesData) {
            JsonObject displayNameData = element.getAsJsonObject();
            int level = displayNameData.get(LEVEL).getAsInt();
            GsonComponentSerializer gsonComponentSerializer = GsonComponentSerializer.builder().build();
            output[level - 1] = gsonComponentSerializer.deserializeFromTree(displayNameData.get("text"));
        }
        return output;
    }

    private static int[] getModifiedCosts(JsonArray minModifiedCosts, int maxLevel) {
        int[] output = new int[maxLevel];
        for (JsonElement element : minModifiedCosts) {
            JsonObject minModifiedCost = element.getAsJsonObject();
            int level = minModifiedCost.get(LEVEL).getAsInt();
            output[level - 1] = minModifiedCost.get(COST).getAsInt();
        }
        return output;
    }
}

