/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.AbstractSkeletonMock;
import be.seeseemelk.mockbukkit.util.AdventureConverters;
import com.google.common.base.Preconditions;
import java.util.UUID;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Sound;
import org.bukkit.entity.Bogged;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Skeleton;
import org.jetbrains.annotations.NotNull;

public class BoggedMock
extends AbstractSkeletonMock
implements Bogged {
    private boolean sheared;

    public BoggedMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public void shear(@NotNull Sound.Source source) {
        Preconditions.checkNotNull((Object)source, (Object)"The source cannot be null");
        if (this.isInWorld()) {
            this.getWorld().playSound((Entity)this, Sound.ENTITY_BOGGED_SHEAR, AdventureConverters.soundSourceToCategory(source), 1.0f, 1.0f);
        }
        this.setSheared(true);
    }

    public boolean readyToBeSheared() {
        return !this.isSheared() && !this.isDead();
    }

    @NotNull
    public Skeleton.SkeletonType getSkeletonType() {
        return Skeleton.SkeletonType.BOGGED;
    }

    public boolean isSheared() {
        return this.sheared;
    }

    public void setSheared(boolean flag) {
        this.sheared = flag;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.BOGGED;
    }
}

