/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.entity.Display;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DisplayMock
extends EntityMock
implements Display {
    private Matrix4f transformationMatrix = new Matrix4f();
    private int interpolationDuration = 0;
    private int teleportDuration = 0;
    private float viewRange = 1.0f;
    private float shadowRadius = 0.0f;
    private float shadowStrength = 1.0f;
    private float width = 0.0f;
    private float height = 0.0f;
    private int interpolationDelay = 0;
    private int color = -1;
    private Display.Brightness brightness = null;

    protected DisplayMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
        this.transformationMatrix.scale((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f));
    }

    @NotNull
    public Transformation getTransformation() {
        float f = 1.0f / this.transformationMatrix.m33();
        Vector3f translation = this.transformationMatrix.getTranslation(new Vector3f()).mul(f);
        Quaternionf leftRotation = this.transformationMatrix.getUnnormalizedRotation(new Quaternionf());
        Vector3f scale = this.transformationMatrix.getScale(new Vector3f());
        Quaternionf rightRotation = leftRotation.conjugate();
        return new Transformation(translation, leftRotation, scale, rightRotation);
    }

    public void setTransformation(@NotNull Transformation transformation) {
        Preconditions.checkArgument((transformation != null ? 1 : 0) != 0, (Object)"Transformation cannot be null");
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.translation((Vector3fc)transformation.getTranslation());
        matrix4f.rotate((Quaternionfc)transformation.getLeftRotation());
        matrix4f.scale((Vector3fc)transformation.getScale());
        matrix4f.rotate((Quaternionfc)transformation.getRightRotation());
        this.transformationMatrix = matrix4f;
    }

    public void setTransformationMatrix(@NotNull Matrix4f transformationMatrix) {
        Preconditions.checkArgument((transformationMatrix != null ? 1 : 0) != 0, (Object)"Transformation matrix cannot be null");
        try {
            this.transformationMatrix = (Matrix4f)transformationMatrix.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Could not clone transformation matrix");
        }
    }

    public int getInterpolationDuration() {
        return this.interpolationDuration;
    }

    public void setInterpolationDuration(int duration) {
        this.interpolationDuration = duration;
    }

    public int getTeleportDuration() {
        return this.teleportDuration;
    }

    public void setTeleportDuration(int duration) {
        Preconditions.checkArgument((duration >= 0 && duration <= 59 ? 1 : 0) != 0, (String)"duration (%s) cannot be lower than 0 or higher than 59", (int)duration);
        this.teleportDuration = duration;
    }

    public float getViewRange() {
        return this.viewRange;
    }

    public void setViewRange(float range) {
        this.viewRange = range;
    }

    public float getShadowRadius() {
        return this.shadowRadius;
    }

    public void setShadowRadius(float radius) {
        this.shadowRadius = radius;
    }

    public float getShadowStrength() {
        return this.shadowStrength;
    }

    public void setShadowStrength(float strength) {
        this.shadowStrength = strength;
    }

    public float getDisplayWidth() {
        return this.width;
    }

    public void setDisplayWidth(float width) {
        this.width = width;
    }

    public float getDisplayHeight() {
        return this.height;
    }

    public void setDisplayHeight(float height) {
        this.height = height;
    }

    public int getInterpolationDelay() {
        return this.interpolationDelay;
    }

    public void setInterpolationDelay(int ticks) {
        this.interpolationDelay = ticks;
    }

    @NotNull
    public Display.Billboard getBillboard() {
        throw new UnimplementedOperationException();
    }

    public void setBillboard(@NotNull Display.Billboard billboard) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Color getGlowColorOverride() {
        return this.color == -1 ? null : Color.fromARGB((int)this.color);
    }

    public void setGlowColorOverride(@Nullable Color color) {
        this.color = color == null ? -1 : color.asARGB();
    }

    @Nullable
    public Display.Brightness getBrightness() {
        return this.cloneBrightness(this.brightness);
    }

    public void setBrightness(@Nullable Display.Brightness brightness) {
        this.brightness = this.cloneBrightness(brightness);
    }

    @Nullable
    private Display.Brightness cloneBrightness(@Nullable Display.Brightness inputBrightness) {
        if (inputBrightness == null) {
            return null;
        }
        return new Display.Brightness(inputBrightness.getBlockLight(), inputBrightness.getSkyLight());
    }
}

