/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.inventory.ItemStackMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderSignalMock
extends EntityMock
implements EnderSignal {
    private static final String TARGET_NOT_SET_ERROR = "Target location has not been set! Mockbukkit requires that the target location be set before the location is retrieved.";
    private Location targetLocation = null;
    private boolean surviveAfterDeath = true;
    private ItemStack item = new ItemStackMock(Material.ENDER_EYE);
    private int life = 0;

    public EnderSignalMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @NotNull
    public Location getTargetLocation() {
        Preconditions.checkState((this.targetLocation != null ? 1 : 0) != 0, (Object)TARGET_NOT_SET_ERROR);
        return this.targetLocation;
    }

    public void setTargetLocation(@NotNull Location location) {
        this.setTargetLocation(location, true);
    }

    public void setTargetLocation(@NotNull Location location, boolean update) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((boolean)this.getWorld().equals(location.getWorld()), (Object)"Cannot target EnderSignal across worlds");
        this.targetLocation = location.toBlockLocation();
        if (update) {
            // empty if block
        }
    }

    public boolean getDropItem() {
        return this.surviveAfterDeath;
    }

    public void setDropItem(boolean drop) {
        this.surviveAfterDeath = drop;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(@Nullable ItemStack item) {
        if (item == null) {
            this.item = new ItemStackMock(Material.ENDER_EYE);
            return;
        }
        this.item = item.clone();
    }

    public int getDespawnTimer() {
        return this.life;
    }

    public void setDespawnTimer(int timer) {
        this.life = timer;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.EYE_OF_ENDER;
    }
}

