/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.SpellcasterMock;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Spellcaster;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvokerMock
extends SpellcasterMock
implements Evoker {
    private Sheep wololoTarget;

    public EvokerMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @NotNull
    public Evoker.Spell getCurrentSpell() {
        return EvokerMock.toEvokerSpell(this.getSpell());
    }

    public void setCurrentSpell(@Nullable Evoker.Spell spell) {
        this.setSpell(EvokerMock.toSpellcasterSpell(spell));
    }

    @Nullable
    public Sheep getWololoTarget() {
        return this.wololoTarget;
    }

    public void setWololoTarget(@Nullable Sheep sheep) {
        this.wololoTarget = sheep;
    }

    @NotNull
    public Sound getCelebrationSound() {
        return Sound.ENTITY_EVOKER_CELEBRATE;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.EVOKER;
    }

    @NotNull
    private static Spellcaster.Spell toSpellcasterSpell(@Nullable Evoker.Spell spell) {
        if (spell == null) {
            return Spellcaster.Spell.NONE;
        }
        return Spellcaster.Spell.values()[spell.ordinal()];
    }

    @NotNull
    private static Evoker.Spell toEvokerSpell(@Nullable Spellcaster.Spell spell) {
        if (spell == null) {
            return Evoker.Spell.NONE;
        }
        return Evoker.Spell.values()[spell.ordinal()];
    }
}

