/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.block.state.BlockStateMock;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.jetbrains.annotations.NotNull;

public class FallingBlockMock
extends EntityMock
implements FallingBlock {
    private BlockState blockState = new BlockStateMock(Material.SAND);
    private boolean dropItem = true;
    private boolean canHurtEntities;
    private boolean autoExpire;
    private boolean cancelDrop;
    private float damagePerBlock;
    private int maximumDamage;

    public FallingBlockMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @NotNull
    public Material getMaterial() {
        return this.getBlockData().getMaterial();
    }

    @NotNull
    public BlockData getBlockData() {
        return this.getBlockState().getBlockData();
    }

    public void setBlockData(@NotNull BlockData blockData) {
        Preconditions.checkArgument((blockData != null ? 1 : 0) != 0, (Object)"blockData");
        this.blockState = blockData.createBlockState();
    }

    @NotNull
    public BlockState getBlockState() {
        return this.blockState;
    }

    public void setBlockState(@NotNull BlockState blockState) {
        Preconditions.checkArgument((blockState != null ? 1 : 0) != 0, (Object)"blockState");
        this.setBlockData(blockState.getBlockData());
    }

    public boolean getDropItem() {
        return this.dropItem;
    }

    public void setDropItem(boolean dropItem) {
        this.dropItem = dropItem;
    }

    public boolean getCancelDrop() {
        return this.cancelDrop;
    }

    public void setCancelDrop(boolean cancelDrop) {
        this.cancelDrop = cancelDrop;
    }

    public boolean canHurtEntities() {
        return this.canHurtEntities;
    }

    public void setHurtEntities(boolean canHurtEntities) {
        this.canHurtEntities = canHurtEntities;
    }

    public float getDamagePerBlock() {
        return this.damagePerBlock;
    }

    public void setDamagePerBlock(float damage) {
        Preconditions.checkArgument(((double)damage >= 0.0 ? 1 : 0) != 0, (String)"damage must be >= 0.0, given %s", (Object)Float.valueOf(damage));
        this.damagePerBlock = damage;
        if ((double)damage > 0.0) {
            this.setHurtEntities(true);
        }
    }

    public int getMaxDamage() {
        return this.maximumDamage;
    }

    public void setMaxDamage(int damage) {
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0, (String)"damage must be >= 0, given %s", (int)damage);
        this.maximumDamage = damage;
        if (damage > 0) {
            this.setHurtEntities(true);
        }
    }

    public boolean doesAutoExpire() {
        return this.autoExpire;
    }

    public void shouldAutoExpire(boolean autoExpire) {
        this.autoExpire = autoExpire;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.FALLING_BLOCK;
    }
}

