/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.ProjectileMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class FishHookMock
extends ProjectileMock
implements FishHook {
    private int minWaitTime = 100;
    private int maxWaitTime = 600;
    private int minLureTime = 20;
    private int maxLureTime = 80;
    private float minLureAngle = 0.0f;
    private float maxLureAngle = 360.0f;
    private boolean applyLure = true;
    private boolean skyInfluenced = true;
    private boolean rainInfluenced = true;
    private double biteChance = -1.0;
    @Nullable
    private Entity hookedEntity;
    @NotNull
    private FishHook.HookState state = FishHook.HookState.UNHOOKED;

    public FishHookMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public int getMinWaitTime() {
        return this.minWaitTime;
    }

    public void setMinWaitTime(int minWaitTime) {
        Preconditions.checkArgument((minWaitTime >= 0 && minWaitTime <= this.getMaxWaitTime() ? 1 : 0) != 0, (Object)"The minimum wait time should be between 0 and the maximum wait time.");
        this.minWaitTime = minWaitTime;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        Preconditions.checkArgument((maxWaitTime >= 0 && maxWaitTime >= this.getMinWaitTime() ? 1 : 0) != 0, (Object)"The maximum wait time should be higher than or equal to 0 and the minimum wait time.");
        this.maxWaitTime = maxWaitTime;
    }

    public void setWaitTime(int min, int max) {
        this.setMinWaitTime(min);
        this.setMaxWaitTime(max);
    }

    public int getMinLureTime() {
        return this.minLureTime;
    }

    public void setMinLureTime(int minLureTime) {
        Preconditions.checkArgument((minLureTime >= 0 && minLureTime <= this.getMaxLureTime() ? 1 : 0) != 0, (Object)"The minimum lure time should be between 0 and the maximum lure time.");
        this.minLureTime = minLureTime;
    }

    public int getMaxLureTime() {
        return this.maxLureTime;
    }

    public void setMaxLureTime(int maxLureTime) {
        Preconditions.checkArgument((maxLureTime >= 0 && maxLureTime >= this.getMinLureTime() ? 1 : 0) != 0, (Object)"The maximum lure time should be higher than or equal to 0 and the minimum lure time.");
        this.maxLureTime = maxLureTime;
    }

    public void setLureTime(int min, int max) {
        this.setMinLureTime(min);
        this.setMaxLureTime(max);
    }

    public float getMinLureAngle() {
        return this.minLureAngle;
    }

    public void setMinLureAngle(float minLureAngle) {
        Preconditions.checkArgument((minLureAngle >= 0.0f && minLureAngle <= this.getMaxLureAngle() ? 1 : 0) != 0, (Object)"The minimum lure angle should be between 0 and the maximum lure angle.");
        this.minLureAngle = minLureAngle;
    }

    public float getMaxLureAngle() {
        return this.maxLureAngle;
    }

    public void setMaxLureAngle(float maxLureAngle) {
        Preconditions.checkArgument((maxLureAngle >= 0.0f && maxLureAngle >= this.getMinLureAngle() && maxLureAngle <= 360.0f ? 1 : 0) != 0, (Object)"The maximum lure angle should be higher than or equal to 0 and the minimum lure angle but also less than or equal to 360.");
        this.maxLureAngle = maxLureAngle;
    }

    public void setLureAngle(float min, float max) {
        this.setMinLureAngle(min);
        this.setMaxLureAngle(max);
    }

    public boolean getApplyLure() {
        return this.applyLure;
    }

    public void setApplyLure(boolean applyLure) {
        this.applyLure = applyLure;
    }

    public double getBiteChance() {
        if (this.biteChance == -1.0) {
            if (!this.getWorld().isClearWeather()) {
                return 0.0033333333333333335;
            }
            return 0.002;
        }
        return this.biteChance;
    }

    public void setBiteChance(double chance) throws IllegalArgumentException {
        Preconditions.checkArgument((chance >= 0.0 && chance <= 1.0 ? 1 : 0) != 0, (Object)"The bite chance must be between 0 and 1.");
        this.biteChance = chance;
    }

    public boolean isInOpenWater() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Entity getHookedEntity() {
        return this.hookedEntity;
    }

    public void setHookedEntity(@Nullable Entity entity) {
        this.state = FishHook.HookState.HOOKED_ENTITY;
        this.hookedEntity = entity;
    }

    public boolean pullHookedEntity() {
        if (this.hookedEntity == null) {
            return false;
        }
        ProjectileSource projectileSource = this.getShooter();
        if (projectileSource instanceof Entity) {
            Entity shooter = (Entity)projectileSource;
            Location shooterLoc = shooter.getLocation();
            Location hookLoc = this.getLocation();
            Vector velocity = new Vector(shooterLoc.getX() - hookLoc.getX(), shooterLoc.getY() - hookLoc.getY(), shooterLoc.getZ() - hookLoc.getZ()).multiply(0.1);
            this.hookedEntity.setVelocity(this.hookedEntity.getVelocity().add(velocity));
        }
        return true;
    }

    public boolean isSkyInfluenced() {
        return this.skyInfluenced;
    }

    public void setSkyInfluenced(boolean skyInfluenced) {
        this.skyInfluenced = skyInfluenced;
    }

    public boolean isRainInfluenced() {
        return this.rainInfluenced;
    }

    public void setRainInfluenced(boolean rainInfluenced) {
        this.rainInfluenced = rainInfluenced;
    }

    public void updateState() {
        this.state = this.hookedEntity != null ? FishHook.HookState.HOOKED_ENTITY : (this.getLocation().getBlock().isLiquid() ? FishHook.HookState.BOBBING : FishHook.HookState.UNHOOKED);
    }

    @NotNull
    public FishHook.HookState getState() {
        return this.state;
    }

    public int getWaitTime() {
        throw new UnimplementedOperationException();
    }

    public void setWaitTime(int ticks) {
        throw new UnimplementedOperationException();
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int getTimeUntilBite() {
        throw new UnimplementedOperationException();
    }

    public void setTimeUntilBite(@Range(from=1L, to=0x7FFFFFFFL) int i) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public void resetFishingState() {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.FISHING_BOBBER;
    }

    @Override
    @NotNull
    public SpawnCategory getSpawnCategory() {
        return SpawnCategory.MISC;
    }

    @NotNull
    public String toString() {
        return "FishingHookMock";
    }
}

