/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.HangingMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Rotation;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFrameMock
extends HangingMock
implements ItemFrame {
    private ItemStack itemStack = ItemStack.empty();
    private Rotation rotation = Rotation.NONE;
    private float dropChance = 1.0f;
    private boolean visible = true;
    private boolean fixed = false;

    public ItemFrameMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @NotNull
    public ItemStack getItem() {
        return this.itemStack;
    }

    public void setItem(@Nullable ItemStack item) {
        this.setItem(item, true);
    }

    public void setItem(@Nullable ItemStack item, boolean playSound) {
        ItemStack itemStack = this.itemStack = item == null || item.isEmpty() ? ItemStack.empty() : item.clone();
        if (!this.itemStack.isEmpty() && playSound && this.isInWorld()) {
            this.getWorld().playSound((Entity)this, Sound.ENTITY_ITEM_FRAME_ADD_ITEM, 1.0f, 1.0f);
        }
    }

    public float getItemDropChance() {
        return this.dropChance;
    }

    public void setItemDropChance(float chance) {
        Preconditions.checkArgument((0.0 <= (double)chance && (double)chance <= 1.0 ? 1 : 0) != 0, (String)"Chance (%s) outside range [0, 1]", (Object)Float.valueOf(chance));
        this.dropChance = chance;
    }

    @NotNull
    public Rotation getRotation() {
        return this.rotation;
    }

    public void setRotation(@NotNull Rotation rotation) throws IllegalArgumentException {
        Preconditions.checkArgument((rotation != null ? 1 : 0) != 0, (Object)"Rotation cannot be null");
        this.rotation = rotation;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.ITEM_FRAME;
    }
}

