/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.ThrowableProjectileMock;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;

public class ThrownPotionMock
extends ThrowableProjectileMock
implements ThrownPotion {
    @NotNull
    private ItemStack potionItem = new ItemStack(Material.SPLASH_POTION);

    public ThrownPotionMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @NotNull
    public Collection<PotionEffect> getEffects() {
        return this.getPotionMeta().getCustomEffects();
    }

    @NotNull
    public PotionMeta getPotionMeta() {
        return (PotionMeta)this.potionItem.getItemMeta();
    }

    public void setPotionMeta(@NotNull PotionMeta meta) {
        Preconditions.checkArgument((meta != null ? 1 : 0) != 0, (Object)"PotionMeta cannot be null");
        this.potionItem.setItemMeta((ItemMeta)meta.clone());
    }

    public void splash() {
        throw new UnimplementedOperationException("Splash function was not implemented yet!");
    }

    @NotNull
    public ItemStack getItem() {
        return this.potionItem.clone();
    }

    public void setItem(@NotNull ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        PotionMeta meta = Material.LINGERING_POTION.equals((Object)item.getType()) || Material.SPLASH_POTION.equals((Object)item.getType()) ? null : this.getPotionMeta();
        this.potionItem = item.clone();
        if (meta != null) {
            this.setPotionMeta(meta);
        }
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.POTION;
    }
}

