/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import com.google.common.base.Preconditions;
import org.bukkit.block.BrewingStand;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewerInventoryMock
extends InventoryMock
implements BrewerInventory {
    private static final int INGREDIENT_SLOT = 3;
    private static final int FUEL_SLOT = 4;

    public BrewerInventoryMock(InventoryHolder holder) {
        super(holder, InventoryType.BREWING);
    }

    @Nullable
    public ItemStack getIngredient() {
        this.checkHasIngredient();
        return this.getItem(3);
    }

    public void setIngredient(@Nullable ItemStack ingredient) {
        Preconditions.checkNotNull((Object)ingredient, (Object)"Ingredient cannot be null");
        this.setItem(3, ingredient);
    }

    @Nullable
    public ItemStack getFuel() {
        this.checkHasFuel();
        return this.getItem(4);
    }

    public void setFuel(@Nullable ItemStack fuel) {
        Preconditions.checkNotNull((Object)fuel, (Object)"Fuel cannot be null");
        this.setItem(4, fuel);
    }

    public BrewingStand getHolder() {
        return (BrewingStand)super.getHolder();
    }

    @Override
    @NotNull
    public BrewerInventoryMock getSnapshot() {
        BrewerInventoryMock inventory = new BrewerInventoryMock((InventoryHolder)this.getHolder());
        inventory.setItem(3, this.getItem(3));
        inventory.setItem(4, this.getItem(4));
        return inventory;
    }

    private void checkHasFuel() {
        Preconditions.checkState((this.getItem(4) != null ? 1 : 0) != 0, (Object)"No fuel has been set");
    }

    private void checkHasIngredient() {
        Preconditions.checkState((this.getItem(3) != null ? 1 : 0) != 0, (Object)"No ingredient has been set");
    }
}

