/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.inventory.ItemStackMock;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockType;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ItemTypeMock<M extends ItemMeta>
implements ItemType.Typed<M> {
    private final NamespacedKey namespacedKey;
    private final boolean blockType;
    private final int maxStackSize;
    private final short maxDurability;
    private final boolean edible;
    private final boolean hasRecord;
    private final boolean fuel;
    private final String translationKey;
    private final Class<M> metaClass;
    private final ItemRarity rarity;
    private final CreativeCategory creativeCategory;
    private final boolean isCompostable;
    private final BigDecimal compostChance;

    private ItemTypeMock(NamespacedKey namespacedKey, int maxStackSize, short maxDurability, boolean edible, boolean hasRecord, boolean fuel, boolean blockType, String translationKey, Class<M> metaClass, ItemRarity rarity, CreativeCategory creativeCategory, boolean isCompostable, BigDecimal compostChance) {
        this.namespacedKey = namespacedKey;
        this.maxStackSize = maxStackSize;
        this.maxDurability = maxDurability;
        this.edible = edible;
        this.hasRecord = hasRecord;
        this.fuel = fuel;
        this.blockType = blockType;
        this.translationKey = translationKey;
        this.metaClass = metaClass;
        this.rarity = rarity;
        this.creativeCategory = creativeCategory;
        this.isCompostable = isCompostable;
        this.compostChance = compostChance;
    }

    @ApiStatus.Internal
    public static ItemType from(JsonObject jsonObject) {
        NamespacedKey key = NamespacedKey.fromString((String)jsonObject.get("key").getAsString());
        int maxStackSize = jsonObject.get("maxStackSize").getAsInt();
        short maxDurability = jsonObject.get("maxDurability").getAsShort();
        boolean edible = jsonObject.get("edible").getAsBoolean();
        boolean hasRecord = jsonObject.get("record").getAsBoolean();
        boolean fuel = jsonObject.get("fuel").getAsBoolean();
        boolean blockType = jsonObject.get("blockType").getAsBoolean();
        String translationKey = jsonObject.get("translationKey").getAsString();
        ItemRarity rarity = ItemRarity.valueOf((String)jsonObject.get("rarity").getAsString());
        CreativeCategory creativeCategory = CreativeCategory.valueOf((String)jsonObject.get("creativeCategory").getAsString());
        boolean isCompostable = jsonObject.get("compostable").getAsBoolean();
        BigDecimal compostChance = new BigDecimal(0);
        if (isCompostable) {
            compostChance = BigDecimal.valueOf(jsonObject.get("compostChance").getAsFloat());
        }
        Class metaClass = null;
        String metaClassKey = "metaClass";
        if (jsonObject.has(metaClassKey)) {
            String metaClassAsString = jsonObject.get(metaClassKey).getAsString();
            try {
                if (metaClassAsString.equals("BlockStateMeta") || metaClassAsString.equals("BlockDataMeta") || metaClassAsString.equals("EnchantmentStorageMeta") || metaClassAsString.equals("MusicInstrumentMeta")) {
                    metaClass = ItemMetaMock.class;
                } else {
                    String metaClassName = "be.seeseemelk.mockbukkit.inventory.meta." + jsonObject.get(metaClassKey).getAsString() + "Mock";
                    metaClass = Class.forName(metaClassName);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find class: " + jsonObject.get(metaClassKey).getAsString());
            }
        }
        return new ItemTypeMock<ItemMetaMock>(key, maxStackSize, maxDurability, edible, hasRecord, fuel, blockType, translationKey, metaClass, rarity, creativeCategory, isCompostable, compostChance);
    }

    @NotNull
    public ItemType.Typed<ItemMeta> typed() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public <M extends ItemMeta> ItemType.Typed<M> typed(@NotNull Class<M> itemMetaType) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack createItemStack() {
        return this.createItemStack(1);
    }

    @NotNull
    public ItemStack createItemStack(int amount) {
        return new ItemStackMock(this.asMaterial(), amount);
    }

    public boolean hasBlockType() {
        return this.blockType;
    }

    @NotNull
    public BlockType getBlockType() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Class<M> getItemMetaClass() {
        if (this == ItemType.AIR) {
            throw new UnsupportedOperationException("Air does not have ItemMeta");
        }
        return this.metaClass;
    }

    @NotNull
    public ItemStack createItemStack(@Nullable Consumer<? super M> metaConfigurator) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack createItemStack(int amount, @Nullable Consumer<? super M> metaConfigurator) {
        throw new UnimplementedOperationException();
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public short getMaxDurability() {
        return this.maxDurability;
    }

    public boolean isEdible() {
        return this.edible;
    }

    public boolean isRecord() {
        return this.hasRecord;
    }

    public boolean isFuel() {
        return this.fuel;
    }

    public boolean isCompostable() {
        return this.isCompostable;
    }

    public float getCompostChance() {
        Preconditions.checkArgument((boolean)this.isCompostable(), (Object)("The item type " + String.valueOf(this.getKey()) + " is not compostable"));
        return this.compostChance.floatValue();
    }

    @Nullable
    public ItemType getCraftingRemainingItem() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public @Unmodifiable Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(@NotNull EquipmentSlot slot) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public CreativeCategory getCreativeCategory() {
        return this.creativeCategory;
    }

    public boolean isEnabledByFeature(@NotNull World world) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Material asMaterial() {
        return (Material)Registry.MATERIAL.get(this.namespacedKey);
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.namespacedKey;
    }

    @NotNull
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Nullable
    public ItemRarity getItemRarity() {
        return this.rarity;
    }

    @NotNull
    public String translationKey() {
        return this.translationKey;
    }
}

