/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorMetaMock
extends ItemMetaMock
implements ArmorMeta {
    private ArmorTrim trim = null;

    public boolean hasTrim() {
        return this.trim != null;
    }

    public void setTrim(@Nullable ArmorTrim trim) {
        this.trim = trim;
    }

    @Nullable
    public ArmorTrim getTrim() {
        return this.trim;
    }

    @Override
    @NotNull
    public ArmorMetaMock clone() {
        ArmorMetaMock armorMetaMock = (ArmorMetaMock)super.clone();
        armorMetaMock.setTrim(this.trim);
        return armorMetaMock;
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        Map<String, Object> serialized = super.serialize();
        if (this.hasTrim()) {
            HashMap<String, String> trimData = new HashMap<String, String>();
            trimData.put("material", this.trim.getMaterial().key().toString());
            trimData.put("pattern", this.trim.getPattern().key().toString());
            serialized.put("trim", trimData);
        }
        return serialized;
    }

    @Override
    protected void deserializeInternal(@NotNull Map<String, Object> args) {
        super.deserializeInternal(args);
        if (args.containsKey("trim")) {
            Map trimData = (Map)args.get("trim");
            TrimMaterial trimMaterial = (TrimMaterial)Registry.TRIM_MATERIAL.get(NamespacedKey.fromString((String)trimData.get("material").toString()));
            TrimPattern trimPattern = (TrimPattern)Registry.TRIM_PATTERN.get(NamespacedKey.fromString((String)trimData.get("pattern").toString()));
            this.setTrim(new ArmorTrim(trimMaterial, trimPattern));
        }
    }

    @NotNull
    public static ArmorMetaMock deserialize(@NotNull Map<String, Object> args) {
        ArmorMetaMock armorMetaMock = new ArmorMetaMock();
        armorMetaMock.deserializeInternal(args);
        return armorMetaMock;
    }
}

