/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class EnchantedBookMetaMock
extends ItemMetaMock
implements EnchantmentStorageMeta {
    @NotNull
    private Map<Enchantment, Integer> storedEnchantments = new HashMap<Enchantment, Integer>();

    public EnchantedBookMetaMock() {
    }

    public EnchantedBookMetaMock(@NotNull EnchantmentStorageMeta meta) {
        super((ItemMeta)meta);
        this.storedEnchantments = new HashMap<Enchantment, Integer>(meta.getStoredEnchants());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + this.storedEnchantments.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof EnchantedBookMetaMock)) {
            return false;
        }
        EnchantedBookMetaMock other = (EnchantedBookMetaMock)obj;
        return this.storedEnchantments.equals(other.storedEnchantments);
    }

    @Override
    @NotNull
    public EnchantedBookMetaMock clone() {
        EnchantedBookMetaMock mock = (EnchantedBookMetaMock)super.clone();
        mock.storedEnchantments = new HashMap<Enchantment, Integer>(this.storedEnchantments);
        return mock;
    }

    public boolean addStoredEnchant(@NotNull Enchantment ench, int level, boolean ignoreLevelRestriction) {
        if (!ignoreLevelRestriction && level < ench.getStartLevel()) {
            return false;
        }
        if (!ignoreLevelRestriction && level > ench.getMaxLevel()) {
            return false;
        }
        Integer prev = this.storedEnchantments.put(ench, level);
        return prev == null || prev != level;
    }

    public int getStoredEnchantLevel(@NotNull Enchantment ench) {
        return this.storedEnchantments.getOrDefault(ench, 0);
    }

    @NotNull
    public Map<Enchantment, Integer> getStoredEnchants() {
        return ImmutableMap.copyOf(this.storedEnchantments);
    }

    public boolean hasConflictingStoredEnchant(@NotNull Enchantment ench) {
        for (Enchantment enchantment : this.storedEnchantments.keySet()) {
            if (!enchantment.conflictsWith(ench)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStoredEnchant(@NotNull Enchantment ench) {
        return this.storedEnchantments.containsKey(ench);
    }

    public boolean hasStoredEnchants() {
        return !this.storedEnchantments.isEmpty();
    }

    public boolean removeStoredEnchant(@NotNull Enchantment ench) throws IllegalArgumentException {
        return this.storedEnchantments.remove(ench) != null;
    }

    @NotNull
    public static EnchantedBookMetaMock deserialize(@NotNull Map<String, Object> args) {
        EnchantedBookMetaMock serialMock = new EnchantedBookMetaMock();
        serialMock.deserializeInternal(args);
        if (args.containsKey("stored-enchantments")) {
            serialMock.storedEnchantments = (Map)((Map)args.get("stored-enchantments")).entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> EnchantedBookMetaMock.getEnchantment((String)entry.getKey()), Map.Entry::getValue));
        }
        return serialMock;
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        Map<String, Object> serialized = super.serialize();
        serialized.put("stored-enchantments", this.storedEnchantments.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> EnchantedBookMetaMock.getEnchantmentKey((Enchantment)entry.getKey()), Map.Entry::getValue)));
        return serialized;
    }

    private static String getEnchantmentKey(Enchantment enchantment) {
        return enchantment.getKey().getKey();
    }

    private static Enchantment getEnchantment(String key) {
        NamespacedKey namespacedKey = NamespacedKey.minecraft((String)key);
        return (Enchantment)Registry.ENCHANTMENT.get(namespacedKey);
    }

    @Override
    protected String getTypeName() {
        return "ENCHANTED";
    }
}

