/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import java.util.Map;
import java.util.Objects;
import org.bukkit.FireworkEffect;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FireworkEffectMetaMock
extends ItemMetaMock
implements FireworkEffectMeta {
    @Nullable
    private FireworkEffect effect;

    public FireworkEffectMetaMock() {
    }

    public FireworkEffectMetaMock(@NotNull FireworkEffectMeta meta) {
        super((ItemMeta)meta);
        this.effect = meta.getEffect();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + (this.effect != null ? this.effect.hashCode() : 0);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof FireworkEffectMetaMock)) {
            return false;
        }
        FireworkEffectMetaMock other = (FireworkEffectMetaMock)obj;
        return Objects.equals(this.effect, other.effect);
    }

    @Override
    @NotNull
    public FireworkEffectMetaMock clone() {
        FireworkEffectMetaMock mock = (FireworkEffectMetaMock)super.clone();
        mock.effect = this.effect;
        return mock;
    }

    public void setEffect(@Nullable FireworkEffect effect) {
        this.effect = effect;
    }

    public boolean hasEffect() {
        return this.effect != null;
    }

    @Nullable
    public FireworkEffect getEffect() {
        return this.effect;
    }

    @NotNull
    public static FireworkEffectMetaMock deserialize(@NotNull Map<String, Object> args) {
        FireworkEffectMetaMock serialMock = new FireworkEffectMetaMock();
        serialMock.deserializeInternal(args);
        if (args.containsKey("effect")) {
            serialMock.effect = (FireworkEffect)FireworkEffect.deserialize((Map)((Map)args.get("effect")));
        }
        return serialMock;
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        Map<String, Object> serialized = super.serialize();
        if (this.effect != null) {
            serialized.put("effect", this.effect.serialize());
        }
        return serialized;
    }

    @Override
    protected String getTypeName() {
        return "FIREWORK_EFFECT";
    }
}

