/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;
import org.jetbrains.annotations.NotNull;

public class KnowledgeBookMetaMock
extends ItemMetaMock
implements KnowledgeBookMeta {
    private static final int MAX_RECIPES = Short.MAX_VALUE;
    private final List<NamespacedKey> recipes = new ArrayList<NamespacedKey>();

    public KnowledgeBookMetaMock() {
    }

    public KnowledgeBookMetaMock(@NotNull KnowledgeBookMeta meta) {
        super((ItemMeta)meta);
        this.recipes.addAll(meta.getRecipes());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + this.recipes.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof KnowledgeBookMetaMock)) {
            return false;
        }
        KnowledgeBookMetaMock other = (KnowledgeBookMetaMock)obj;
        return this.recipes.equals(other.recipes);
    }

    @Override
    @NotNull
    public KnowledgeBookMetaMock clone() {
        KnowledgeBookMetaMock mock = (KnowledgeBookMetaMock)super.clone();
        mock.recipes.addAll(this.recipes);
        return mock;
    }

    public void addRecipe(NamespacedKey ... recipes) {
        for (NamespacedKey recipe : recipes) {
            if (this.recipes.size() >= Short.MAX_VALUE) {
                return;
            }
            if (recipe == null) continue;
            this.recipes.add(recipe);
        }
    }

    @NotNull
    public List<NamespacedKey> getRecipes() {
        return Collections.unmodifiableList(this.recipes);
    }

    public boolean hasRecipes() {
        return !this.recipes.isEmpty();
    }

    public void setRecipes(@NotNull List<NamespacedKey> recipes) {
        this.recipes.clear();
        this.addRecipe(recipes.toArray(new NamespacedKey[0]));
    }

    @NotNull
    public static KnowledgeBookMetaMock deserialize(@NotNull Map<String, Object> args) {
        KnowledgeBookMetaMock serialMock = new KnowledgeBookMetaMock();
        serialMock.deserializeInternal(args);
        if (args.containsKey("recipes")) {
            serialMock.addRecipe((NamespacedKey[])((List)args.get("recipes")).stream().map(NamespacedKey::fromString).toArray(NamespacedKey[]::new));
        }
        return serialMock;
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        Map<String, Object> serialized = super.serialize();
        serialized.put("recipes", this.recipes.stream().map(NamespacedKey::toString).toList());
        return serialized;
    }

    @Override
    protected String getTypeName() {
        return "KNOWLEDGE_BOOK";
    }
}

