/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Color;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapMetaMock
extends ItemMetaMock
implements MapMeta {
    private static final byte SCALING_EMPTY = 0;
    private static final byte SCALING_TRUE = 1;
    private static final byte SCALING_FALSE = 2;
    private Integer mapId;
    @Nullable
    private MapView mapView;
    @Nullable
    private Color color;
    private byte scaling = 0;

    public MapMetaMock() {
    }

    public MapMetaMock(@NotNull MapMeta meta) {
        super((ItemMeta)meta);
        if (meta.hasMapId()) {
            this.mapId = meta.getMapId();
        }
        this.mapView = meta.getMapView();
        this.color = meta.getColor();
        if (meta instanceof MapMetaMock) {
            MapMetaMock metaMock = (MapMetaMock)meta;
            this.scaling = metaMock.scaling;
        } else {
            this.scaling = meta.isScaling() ? (byte)1 : (byte)2;
        }
    }

    public boolean hasMapId() {
        return this.mapId != null;
    }

    public int getMapId() {
        if (this.mapId == null) {
            throw new IllegalStateException("Map ID is not set. Are you checking #hasMapId() first?");
        }
        return this.mapId;
    }

    public void setMapId(int id) {
        this.mapId = id;
    }

    public boolean hasMapView() {
        return this.mapView != null;
    }

    @Nullable
    public MapView getMapView() {
        return this.mapView;
    }

    public void setMapView(MapView map) {
        this.mapView = map;
    }

    public boolean isScaling() {
        return this.scaling == 1;
    }

    public void setScaling(boolean scaling) {
        this.scaling = (byte)(scaling ? 1 : 2);
    }

    public boolean hasLocationName() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public String getLocationName() {
        throw new UnimplementedOperationException();
    }

    public void setLocationName(@Nullable String name) {
        throw new UnimplementedOperationException();
    }

    public boolean hasColor() {
        return this.color != null;
    }

    @Nullable
    public Color getColor() {
        return this.color;
    }

    public void setColor(@Nullable Color color) {
        this.color = color;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.mapId == null ? 0 : this.mapId.hashCode());
        result = 31 * result + (this.mapView == null ? 0 : this.mapView.hashCode());
        result = 31 * result + this.scaling;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MapMeta)) {
            return false;
        }
        MapMeta meta = (MapMeta)obj;
        if (!super.equals(obj) || (this.hasMapId() || meta.hasMapId()) && !Objects.equals(this.mapId, meta.getMapId()) || !Objects.equals(this.mapView, meta.getMapView()) || !Objects.equals(this.color, meta.getColor())) {
            return false;
        }
        if (meta instanceof MapMetaMock) {
            MapMetaMock mapMeta = (MapMetaMock)meta;
            return this.scaling == mapMeta.scaling;
        }
        return meta.isScaling() ? this.scaling == 1 : this.scaling == 2;
    }

    @Override
    @NotNull
    public MapMetaMock clone() {
        MapMetaMock clone = (MapMetaMock)super.clone();
        clone.color = this.color;
        clone.mapId = this.mapId;
        clone.mapView = this.mapView;
        clone.scaling = this.scaling;
        return clone;
    }

    @NotNull
    public static MapMetaMock deserialize(@NotNull Map<String, Object> args) {
        MapMetaMock serialMock = new MapMetaMock();
        serialMock.deserializeInternal(args);
        serialMock.mapId = (Integer)args.get("map-id");
        serialMock.mapView = (MapView)args.get("map-view");
        if (args.containsKey("color")) {
            serialMock.color = Color.fromARGB((int)((Integer)args.get("color")));
        }
        serialMock.scaling = (Byte)args.get("scaling");
        return serialMock;
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        Map<String, Object> serialized = super.serialize();
        if (this.mapId != null) {
            serialized.put("map-id", this.mapId);
        }
        if (this.mapView != null) {
            serialized.put("map-view", this.mapView);
        }
        if (this.color != null) {
            serialized.put("color", this.color.asARGB());
        }
        serialized.put("scaling", this.scaling);
        return serialized;
    }

    @Override
    protected String getTypeName() {
        return "MAP";
    }
}

