/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.bukkit.inventory.meta.OminousBottleMeta;
import org.jetbrains.annotations.NotNull;

public class OminousBottleMetaMock
extends ItemMetaMock
implements OminousBottleMeta {
    private Integer amplifier;
    private static final String AMPLIFIER_KEY = "amplifier";

    public boolean hasAmplifier() {
        return this.amplifier != null;
    }

    public int getAmplifier() {
        Preconditions.checkState((boolean)this.hasAmplifier(), (Object)"'ominous_bottle_amplifier' data component is absent. Check hasAmplifier first!");
        return this.amplifier;
    }

    public void setAmplifier(int amplifier) {
        Preconditions.checkArgument((0 <= amplifier && amplifier <= 4 ? 1 : 0) != 0, (Object)"Amplifier must be in range [0, 4]");
        this.amplifier = amplifier;
    }

    @Override
    @NotNull
    public OminousBottleMetaMock clone() {
        OminousBottleMetaMock clone = (OminousBottleMetaMock)super.clone();
        clone.amplifier = this.amplifier;
        return clone;
    }

    @Override
    protected void deserializeInternal(@NotNull Map<String, Object> args) {
        super.deserializeInternal(args);
        if (args.containsKey(AMPLIFIER_KEY)) {
            this.amplifier = (Integer)args.get(AMPLIFIER_KEY);
        }
    }

    @NotNull
    public static OminousBottleMetaMock deserialize(@NotNull Map<String, Object> args) {
        OminousBottleMetaMock serialMock = new OminousBottleMetaMock();
        serialMock.deserializeInternal(args);
        return serialMock;
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        Map<String, Object> serialized = super.serialize();
        if (this.hasAmplifier()) {
            serialized.put(AMPLIFIER_KEY, this.amplifier);
        }
        return serialized;
    }
}

