/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta.trim;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class TrimPatternMock
implements TrimPattern {
    private final NamespacedKey key;
    private final Component description;
    private final String translationKey;

    @ApiStatus.Internal
    public TrimPatternMock(NamespacedKey key, Component description, String translationKey) {
        this.key = key;
        this.description = description;
        this.translationKey = translationKey;
    }

    @Deprecated(forRemoval=true)
    public TrimPatternMock(JsonObject data) {
        this.key = NamespacedKey.fromString((String)data.get("key").getAsString());
        this.description = GsonComponentSerializer.gson().deserializeFromTree(data.get("description"));
        this.translationKey = data.get("translationKey").getAsString();
    }

    @NotNull
    public Component description() {
        return this.description;
    }

    @NotNull
    public String getTranslationKey() {
        return this.translationKey;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @ApiStatus.Internal
    public static TrimPatternMock from(JsonObject data) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkArgument((boolean)data.has("key"), (Object)"Missing json key");
        NamespacedKey key = NamespacedKey.fromString((String)data.get("key").getAsString());
        Component description = GsonComponentSerializer.gson().deserializeFromTree(data.get("description"));
        String translationKey = data.get("translationKey").getAsString();
        return new TrimPatternMock(key, description, translationKey);
    }
}

