/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.plugin;

import be.seeseemelk.mockbukkit.PermissionManagerMock;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.exception.EventHandlerException;
import be.seeseemelk.mockbukkit.plugin.MockBukkitConfiguredPluginClassLoader;
import be.seeseemelk.mockbukkit.plugin.MockBukkitURLClassLoader;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerEventException;
import com.destroystokyo.paper.exception.ServerException;
import com.google.common.base.Preconditions;
import io.papermc.paper.plugin.PermissionManager;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.bukkit.command.Command;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.PluginCommandUtils;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.junit.jupiter.api.Assertions;

public class PluginManagerMock
extends PermissionManagerMock
implements PluginManager {
    private static final Pattern VALID_PLUGIN_NAMES = Pattern.compile("^[A-Za-z0-9_.-]+$");
    @NotNull
    private final ServerMock server;
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final List<PluginCommand> commands = new ArrayList<PluginCommand>();
    private final List<Event> events = new ArrayList<Event>();
    private File parentTemporaryDirectory;
    @NotNull
    private final Map<String, List<Listener>> listeners = new HashMap<String, List<Listener>>();

    @ApiStatus.Internal
    public PluginManagerMock(@NotNull ServerMock server) {
        Preconditions.checkNotNull((Object)((Object)server), (Object)"Server cannot be null");
        this.server = server;
    }

    public void unload() {
        if (this.parentTemporaryDirectory == null) {
            return;
        }
        try (Stream<Path> walk = Files.walk(this.parentTemporaryDirectory.toPath(), new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            this.server.getLogger().log(Level.SEVERE, "Could not delete temporary directory", e);
        }
    }

    public void assertEventFired(@Nullable String message, @NotNull Predicate<Event> predicate) {
        Preconditions.checkNotNull(predicate, (Object)"Predicate cannot be null");
        for (Event event : this.events) {
            if (!predicate.test(event)) continue;
            return;
        }
        Assertions.fail((String)message);
    }

    public void assertEventFired(@NotNull Predicate<Event> predicate) {
        Preconditions.checkNotNull(predicate, (Object)"Predicate cannot be null");
        this.assertEventFired("Event assert failed", predicate);
    }

    public <T extends Event> void assertEventFired(@Nullable String message, @NotNull Class<T> eventClass, @NotNull Predicate<T> predicate) {
        Preconditions.checkNotNull(eventClass, (Object)"Class cannot be null");
        for (Event event : this.events) {
            if (!eventClass.isInstance(event) || !predicate.test((Event)eventClass.cast(event))) continue;
            return;
        }
        Assertions.fail((String)message);
    }

    public <T extends Event> void assertEventFired(@NotNull Class<T> eventClass, @NotNull Predicate<T> predicate) {
        Preconditions.checkNotNull(eventClass, (Object)"Class cannot be null");
        this.assertEventFired("No event of the correct class tested true", eventClass, predicate);
    }

    public void assertEventFired(@NotNull Class<? extends Event> eventClass) {
        Preconditions.checkNotNull(eventClass, (Object)"Class cannot be null");
        this.assertEventFired("No event of that type has been fired", eventClass::isInstance);
    }

    public void assertEventNotFired(@NotNull Class<? extends Event> eventClass) {
        Preconditions.checkNotNull(eventClass, (Object)"Class cannot be null");
        this.assertEventNotFired(eventClass, "An event of type " + eventClass.getSimpleName() + " has been fired when it shouldn't have been");
    }

    public void assertEventNotFired(@NotNull Class<? extends Event> eventClass, @Nullable String message) {
        Preconditions.checkNotNull(eventClass, (Object)"Class cannot be null");
        for (Event event : this.events) {
            if (!eventClass.isAssignableFrom(event.getClass())) continue;
            Assertions.fail((String)message);
        }
    }

    public Plugin getPlugin(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        for (Plugin plugin : this.plugins) {
            if (!name.equals(plugin.getName())) continue;
            return plugin;
        }
        return null;
    }

    public Plugin @NotNull [] getPlugins() {
        return this.plugins.toArray(new Plugin[0]);
    }

    @NotNull
    public Collection<PluginCommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    private boolean isConstructorCompatible(@NotNull Constructor<?> constructor, @NotNull @NotNull Class<?> @NotNull [] types) {
        Preconditions.checkNotNull(constructor, (Object)"Constructor cannot be null");
        Preconditions.checkNotNull(types, (Object)"Types cannot be null");
        Class<?>[] parameters = constructor.getParameterTypes();
        if (parameters.length < types.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            Preconditions.checkNotNull(type, (Object)"Type cannot be null");
            Class<?> parameter = parameters[i];
            if (parameter.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Constructor<? extends JavaPlugin> getCompatibleConstructor(@NotNull Class<? extends JavaPlugin> class1, @NotNull @NotNull Class<?> @NotNull [] types) throws NoSuchMethodException {
        Preconditions.checkNotNull(class1, (Object)"Class cannot be null");
        Preconditions.checkNotNull(types, (Object)"Types cannot be null");
        for (Constructor<?> constructor : class1.getDeclaredConstructors()) {
            Class<?>[] parameters = constructor.getParameterTypes();
            if (parameters.length != types.length || !this.isConstructorCompatible(constructor, types)) continue;
            return constructor;
        }
        StringBuilder parameters = new StringBuilder("[");
        for (Class<?> type : types) {
            parameters.append(type.getName()).append(", ");
        }
        String str = parameters.substring(0, parameters.length() - 2) + "]";
        throw new NoSuchMethodException("No compatible constructor for " + class1.getName() + " with parameters " + str);
    }

    @NotNull
    public File getParentTemporaryDirectory() throws IOException {
        if (this.parentTemporaryDirectory == null) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            this.parentTemporaryDirectory = Files.createTempDirectory("MockBukkit-" + random.nextInt(0, Integer.MAX_VALUE), new FileAttribute[0]).toFile();
        }
        return this.parentTemporaryDirectory;
    }

    @NotNull
    public File createTemporaryDirectory(@NotNull String name) throws IOException {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        File directory = new File(this.getParentTemporaryDirectory(), name);
        directory.mkdirs();
        return directory;
    }

    @NotNull
    public File createTemporaryPluginFile(@NotNull String name) throws IOException {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        File pluginFile = new File(this.getParentTemporaryDirectory(), name + ".jar");
        if (!pluginFile.exists() && !pluginFile.createNewFile()) {
            throw new IOException("Could not create file " + pluginFile.getAbsolutePath());
        }
        return pluginFile;
    }

    public void registerLoadedPlugin(@NotNull Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        this.addCommandsFrom(plugin);
        this.plugins.add(plugin);
        plugin.onLoad();
    }

    @NotNull
    public JavaPlugin loadPlugin(@NotNull Class<? extends JavaPlugin> class1, @NotNull PluginDescriptionFile description, @NotNull @NotNull Object @NotNull [] parameters) {
        Preconditions.checkNotNull(class1, (Object)"Class cannot be null");
        Preconditions.checkNotNull((Object)description, (Object)"Description cannot be null");
        Preconditions.checkNotNull((Object)parameters, (Object)"Parameters cannot be null");
        try {
            class1 = this.createClassLoader(description).loadProxyClass(class1);
            ArrayList types = new ArrayList();
            for (Object parameter : parameters) {
                Preconditions.checkNotNull((Object)parameter, (Object)"Parameters cannot be null");
                types.add(parameter.getClass());
            }
            Constructor<? extends JavaPlugin> constructor = this.getCompatibleConstructor(class1, types.toArray(new Class[0]));
            constructor.setAccessible(true);
            JavaPlugin plugin = constructor.newInstance(parameters);
            this.registerLoadedPlugin((Plugin)plugin);
            return plugin;
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate plugin", e);
        }
    }

    private MockBukkitConfiguredPluginClassLoader createClassLoader(PluginDescriptionFile description) throws IOException {
        String name = description.getName();
        if (name.equalsIgnoreCase("bukkit") || name.equalsIgnoreCase("minecraft") || name.equalsIgnoreCase("mojang")) {
            throw new RuntimeException("Restricted Name");
        }
        if (!VALID_PLUGIN_NAMES.matcher(name).matches()) {
            throw new RuntimeException("Invalid name. Must match " + VALID_PLUGIN_NAMES.pattern());
        }
        File dataFolder = this.createTemporaryDirectory(name + "-" + description.getVersion());
        File pluginFile = this.createTemporaryPluginFile(name + "-" + description.getVersion());
        return new MockBukkitConfiguredPluginClassLoader(this.server, description, dataFolder, pluginFile);
    }

    private MockBukkitURLClassLoader createURLClassLoader(File pluginFile, PluginDescriptionFile description) throws IOException {
        String name = description.getName();
        if (name.equalsIgnoreCase("bukkit") || name.equalsIgnoreCase("minecraft") || name.equalsIgnoreCase("mojang")) {
            throw new RuntimeException("Restricted Name");
        }
        if (!VALID_PLUGIN_NAMES.matcher(name).matches()) {
            throw new RuntimeException("Invalid name. Must match " + VALID_PLUGIN_NAMES.pattern());
        }
        File dataFolder = this.createTemporaryDirectory(name + "-" + description.getVersion());
        return new MockBukkitURLClassLoader(pluginFile, this.getClass().getClassLoader(), this.server, description, dataFolder);
    }

    @NotNull
    public JavaPlugin loadPlugin(@NotNull Class<? extends JavaPlugin> class1, Object @NotNull [] parameters) {
        try {
            PluginDescriptionFile description = this.findPluginDescription(class1);
            return this.loadPlugin(class1, description, parameters);
        }
        catch (IOException | InvalidDescriptionException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private PluginDescriptionFile findPluginDescription(@NotNull Class<? extends JavaPlugin> class1) throws IOException, InvalidDescriptionException {
        Preconditions.checkNotNull(class1, (Object)"Class cannot be null");
        Enumeration<URL> resources = class1.getClassLoader().getResources("plugin.yml");
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            PluginDescriptionFile description = new PluginDescriptionFile(url.openStream());
            String mainClass = description.getMain();
            if (!class1.getName().equals(mainClass)) continue;
            return description;
        }
        throw new FileNotFoundException("Could not find file plugin.yml. Maybe forgot to add the 'main' property?");
    }

    public void callEvent(@NotNull Event event) {
        Preconditions.checkNotNull((Object)event, (Object)"Event cannot be null");
        if (event.isAsynchronous() && this.server.isOnMainThread()) {
            throw new IllegalStateException("Asynchronous Events cannot be called on the main Thread.");
        }
        this.events.add(event);
        HandlerList handlers = event.getHandlers();
        for (RegisteredListener listener : handlers.getRegisteredListeners()) {
            this.callRegisteredListener(listener, event);
        }
    }

    public void callEventAsynchronously(@NotNull Event event) {
        this.callEventAsynchronously(event, null);
    }

    public <T extends Event> void callEventAsynchronously(@NotNull T event, @Nullable Consumer<T> func) {
        Preconditions.checkNotNull(event, (Object)"Event cannot be null");
        if (!event.isAsynchronous()) {
            throw new IllegalStateException("Synchronous Events cannot be called asynchronously.");
        }
        this.server.getScheduler().executeAsyncEvent(event, func);
    }

    private void callRegisteredListener(@NotNull RegisteredListener registration, @NotNull Event event) {
        Preconditions.checkNotNull((Object)registration, (Object)"Listener cannot be null");
        Preconditions.checkNotNull((Object)event, (Object)"Event cannot be null");
        if (!registration.getPlugin().isEnabled()) {
            return;
        }
        try {
            registration.callEvent(event);
        }
        catch (EventException eventException) {
            Throwable ex = eventException.getCause();
            if (!(event instanceof ServerExceptionEvent)) {
                String msg = "Could not pass event " + event.getEventName() + " to " + registration.getPlugin().getDescription().getFullName();
                this.callEvent((Event)new ServerExceptionEvent((ServerException)new ServerEventException(msg, ex, registration.getPlugin(), registration.getListener(), event)));
            }
            if (ex instanceof RuntimeException) {
                RuntimeException r = (RuntimeException)ex;
                throw r;
            }
            throw new EventHandlerException(ex);
        }
    }

    public void enablePlugin(@NotNull Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((boolean)(plugin instanceof JavaPlugin), (Object)"Not a JavaPlugin");
        if (!plugin.isEnabled()) {
            JavaPluginUtils.setEnabled((JavaPlugin)plugin, true);
            this.callEvent((Event)new PluginEnableEvent(plugin));
        }
    }

    private void addSection(@NotNull PluginCommand command, @NotNull String name, @UnknownNullability Object value) {
        Preconditions.checkNotNull((Object)command, (Object)"Command cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        switch (name) {
            case "description": {
                Preconditions.checkNotNull((Object)value, (Object)"Value cannot be null");
                Preconditions.checkArgument((boolean)(value instanceof String), (Object)"Not a String");
                command.setDescription((String)value);
                break;
            }
            case "aliases": {
                if (value instanceof List) {
                    command.setAliases(((List)value).stream().map(Object::toString).toList());
                    break;
                }
                if (value != null) {
                    command.setAliases(Collections.singletonList(value.toString()));
                    break;
                }
                command.setAliases(Collections.emptyList());
                break;
            }
            case "permission": {
                Preconditions.checkArgument((value == null || value instanceof String ? 1 : 0) != 0, (Object)"Not a String");
                command.setPermission(value == null ? null : (String)value);
                break;
            }
            case "permission-message": {
                Preconditions.checkArgument((value == null || value instanceof String ? 1 : 0) != 0, (Object)"Not a String");
                command.setPermissionMessage(value == null ? null : (String)value);
                break;
            }
            case "usage": {
                Preconditions.checkNotNull((Object)value, (Object)"Value cannot be null");
                Preconditions.checkArgument((boolean)(value instanceof String), (Object)"Not a String");
                command.setUsage((String)value);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown section " + name + " with value '" + String.valueOf(value) + "'. Are you sure this is allowed here? (Reference guide: https://docs.papermc.io/paper/dev/plugin-yml#commands)");
            }
        }
    }

    protected void addCommandsFrom(@NotNull Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        Map pluginCommands = plugin.getDescription().getCommands();
        for (Map.Entry entry : pluginCommands.entrySet()) {
            PluginCommand command = PluginCommandUtils.createPluginCommand((String)entry.getKey(), plugin);
            for (Map.Entry section : ((Map)entry.getValue()).entrySet()) {
                this.addSection(command, (String)section.getKey(), section.getValue());
            }
            this.commands.add(command);
            this.server.getCommandMap().register(plugin.getName(), (Command)command);
        }
    }

    public void registerInterface(@NotNull Class<? extends PluginLoader> loader) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public boolean isPluginEnabled(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        boolean result = false;
        for (Plugin mockedPlugin : this.plugins) {
            if (!mockedPlugin.getName().equals(name)) continue;
            result = mockedPlugin.isEnabled();
        }
        return result;
    }

    public boolean isPluginEnabled(@Nullable Plugin plugin) {
        boolean result = false;
        for (Plugin mockedPlugin : this.plugins) {
            if (!mockedPlugin.equals((Object)plugin)) continue;
            result = plugin.isEnabled();
        }
        return result;
    }

    public Plugin loadPlugin(@NotNull File file) throws UnknownDependencyException {
        try {
            JarFile jarFile = new JarFile(file);
            PluginDescriptionFile descriptionFile = new PluginDescriptionFile(jarFile.getInputStream(jarFile.getEntry("plugin.yml")));
            MockBukkitURLClassLoader classLoader = this.createURLClassLoader(file, descriptionFile);
            Class<?> pluginClass = classLoader.loadClass(descriptionFile.getMainClass(), true, false, false);
            JavaPlugin plugin = (JavaPlugin)pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.registerLoadedPlugin((Plugin)plugin);
            return plugin;
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | InvalidDescriptionException e) {
            throw new RuntimeException(e);
        }
    }

    public Plugin[] loadPlugins(@NotNull File directory) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Plugin[] loadPlugins(@NotNull File[] files) {
        throw new UnimplementedOperationException();
    }

    public void disablePlugins() {
        for (Plugin plugin : this.plugins) {
            this.disablePlugin(plugin);
        }
    }

    public void clearPlugins() {
        this.disablePlugins();
        this.plugins.clear();
    }

    public void clearEvents() {
        this.events.clear();
    }

    public void registerEvents(@NotNull Listener listener, @NotNull Plugin plugin) {
        Preconditions.checkNotNull((Object)listener, (Object)"Listener cannot be null");
        Preconditions.checkNotNull((Object)plugin, (Object)"Listener cannot be null");
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register " + String.valueOf(listener) + " while not enabled");
        }
        this.addListener(listener, plugin);
        for (Map.Entry entry : plugin.getPluginLoader().createRegisteredListeners(listener, plugin).entrySet()) {
            this.getEventListeners(this.getRegistrationClass((Class)entry.getKey())).registerAll((Collection)entry.getValue());
        }
    }

    private void addListener(@NotNull Listener listener, @NotNull Plugin plugin) {
        Preconditions.checkNotNull((Object)listener, (Object)"Listener cannot be null");
        Preconditions.checkNotNull((Object)plugin, (Object)"Listener cannot be null");
        List l = this.listeners.getOrDefault(plugin.getName(), new ArrayList());
        if (!l.contains(listener)) {
            l.add(listener);
            this.listeners.put(plugin.getName(), l);
        }
    }

    public void unregisterPluginEvents(@NotNull Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Listener cannot be null");
        List<Listener> listListener = this.listeners.get(plugin.getName());
        if (listListener != null) {
            for (Listener l : listListener) {
                for (Map.Entry entry : plugin.getPluginLoader().createRegisteredListeners(l, plugin).entrySet()) {
                    this.getEventListeners(this.getRegistrationClass((Class)entry.getKey())).unregister(plugin);
                }
            }
        }
    }

    public void registerEvent(@NotNull Class<? extends Event> event, @NotNull Listener listener, @NotNull EventPriority priority, @NotNull EventExecutor executor, @NotNull Plugin plugin) {
        this.registerEvent(event, listener, priority, executor, plugin, false);
    }

    public void registerEvent(@NotNull Class<? extends Event> event, @NotNull Listener listener, @NotNull EventPriority priority, @NotNull EventExecutor executor, @NotNull Plugin plugin, boolean ignoreCancelled) {
        Preconditions.checkNotNull((Object)listener, (Object)"Listener cannot be null");
        Preconditions.checkNotNull((Object)listener, (Object)"Listener cannot be null");
        Preconditions.checkNotNull((Object)priority, (Object)"Priority cannot be null");
        Preconditions.checkNotNull((Object)executor, (Object)"Executor cannot be null");
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register " + String.valueOf(event) + " while not enabled");
        }
        this.addListener(listener, plugin);
        this.getEventListeners(event).register(new RegisteredListener(listener, executor, priority, plugin, ignoreCancelled));
    }

    private HandlerList getEventListeners(@NotNull Class<? extends Event> type) {
        Preconditions.checkNotNull(type, (Object)"Type cannot be null");
        try {
            Method method = this.getRegistrationClass(type).getDeclaredMethod("getHandlerList", new Class[0]);
            method.setAccessible(true);
            return (HandlerList)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalPluginAccessException(e.toString());
        }
    }

    @NotNull
    private Class<? extends Event> getRegistrationClass(@NotNull Class<? extends Event> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Class cannot be null");
        try {
            clazz.getDeclaredMethod("getHandlerList", new Class[0]);
            return clazz;
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Event.class) && Event.class.isAssignableFrom(clazz.getSuperclass())) {
                return this.getRegistrationClass(clazz.getSuperclass().asSubclass(Event.class));
            }
            throw new IllegalPluginAccessException("Unable to find handler list for event " + clazz.getName() + ". Static getHandlerList method required!");
        }
    }

    public void disablePlugin(@NotNull Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((boolean)(plugin instanceof JavaPlugin), (Object)"Not a JavaPlugin");
        if (!plugin.isEnabled()) {
            return;
        }
        Level prevLevel = plugin.getLogger().getLevel();
        plugin.getLogger().setLevel(Level.WARNING);
        plugin.getPluginLoader().disablePlugin(plugin);
        plugin.getLogger().setLevel(prevLevel);
        this.unregisterPluginEvents(plugin);
        this.server.getScheduler().cancelTasks(plugin);
        this.server.getServicesManager().unregisterAll(plugin);
        this.server.getMessenger().unregisterIncomingPluginChannel(plugin);
        this.server.getMessenger().unregisterOutgoingPluginChannel(plugin);
    }

    public boolean useTimings() {
        return false;
    }

    public boolean isTransitiveDependency(PluginMeta pluginMeta, PluginMeta dependencyConfig) {
        throw new UnimplementedOperationException();
    }

    public void overridePermissionManager(@NotNull Plugin plugin, @Nullable PermissionManager permissionManager) {
        throw new UnimplementedOperationException();
    }
}

