/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.potion;

import be.seeseemelk.mockbukkit.MockBukkit;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionUtils {
    private static final BiMap<PotionType, PotionType> upgradeable;
    private static final BiMap<PotionType, PotionType> extendable;

    private PotionUtils() {
    }

    @NotNull
    private static BiMap<PotionType, PotionType> loadData(String filename, String prefix) throws IOException {
        String path = "/potion/type_mapping/" + filename + ".json";
        if (MockBukkit.class.getResource(path) == null) {
            throw new FileNotFoundException(path);
        }
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(MockBukkit.class.getResourceAsStream(path), StandardCharsets.UTF_8));){
            JsonArray values = JsonParser.parseReader((Reader)reader).getAsJsonObject().getAsJsonArray("values");
            for (JsonElement element : values) {
                String key = element.getAsString();
                PotionType original = PotionType.valueOf((String)key);
                PotionType mapped = PotionType.valueOf((String)(prefix + key));
                builder.put((Object)original, (Object)mapped);
            }
        }
        return builder.build();
    }

    @Nullable
    public static PotionType fromBukkit(@Nullable PotionData data) {
        if (data == null) {
            return null;
        }
        PotionType type = data.isUpgraded() ? (PotionType)upgradeable.get((Object)data.getType()) : (data.isExtended() ? (PotionType)extendable.get((Object)data.getType()) : data.getType());
        Preconditions.checkNotNull((Object)type, (Object)("Unknown potion type from data " + String.valueOf(data)));
        return type;
    }

    @Nullable
    public static PotionData toBukkit(@Nullable PotionType type) {
        if (type == null) {
            return null;
        }
        PotionType potionType = (PotionType)extendable.inverse().get((Object)type);
        if (potionType != null) {
            return new PotionData(potionType, true, false);
        }
        potionType = (PotionType)upgradeable.inverse().get((Object)type);
        if (potionType != null) {
            return new PotionData(potionType, false, true);
        }
        return new PotionData(type, false, false);
    }

    static {
        try {
            upgradeable = PotionUtils.loadData("upgradeable", "STRONG_");
            extendable = PotionUtils.loadData("extendable", "LONG_");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

