/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.services;

import be.seeseemelk.mockbukkit.BuildParameters;
import io.papermc.paper.ServerBuildInfo;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.OptionalInt;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;

public class ServerBuildInfoMock
implements ServerBuildInfo {
    private static final Key BRAND_MOCKBUKKIT_ID = Key.key((String)"mockbukkit:mockbukkit");
    private static final String BUILD_DEV = "DEV";

    @NotNull
    public Key brandId() {
        return BRAND_MOCKBUKKIT_ID;
    }

    public boolean isBrandCompatible(@NotNull Key key) {
        return key.equals((Object)BRAND_PAPER_ID) || key.equals((Object)BRAND_MOCKBUKKIT_ID);
    }

    @NotNull
    public String brandName() {
        return "MockBukkit";
    }

    @NotNull
    public String minecraftVersionId() {
        return this.minecraftVersionName();
    }

    @NotNull
    public String minecraftVersionName() {
        return "1.21.1-R0.1-SNAPSHOT".split("-")[0];
    }

    @NotNull
    public OptionalInt buildNumber() {
        return "1518".isEmpty() ? OptionalInt.empty() : OptionalInt.of(Integer.parseInt("1518"));
    }

    @NotNull
    public Instant buildTime() {
        return Instant.ofEpochMilli(BuildParameters.BUILD_TIME);
    }

    @NotNull
    public Optional<String> gitBranch() {
        return Optional.of("HEAD");
    }

    @NotNull
    public Optional<String> gitCommit() {
        return Optional.of("459c56c622ffcad8f3db540a5d444ee4fbe29353");
    }

    @NotNull
    public String asString(@NotNull ServerBuildInfo.StringRepresentation stringRepresentation) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.minecraftVersionId());
        sb.append('-');
        if (this.buildNumber().isPresent()) {
            sb.append(this.buildNumber().getAsInt());
        } else {
            sb.append(BUILD_DEV);
        }
        boolean hasGitBranch = this.gitBranch().isPresent();
        boolean hasGitCommit = this.gitCommit().isPresent();
        if (hasGitBranch || hasGitCommit) {
            sb.append('-');
        }
        if (hasGitBranch && stringRepresentation == ServerBuildInfo.StringRepresentation.VERSION_FULL) {
            sb.append(this.gitBranch().get());
            if (hasGitCommit) {
                sb.append('@');
            }
        }
        if (hasGitCommit) {
            sb.append(this.gitCommit().get());
        }
        if (stringRepresentation == ServerBuildInfo.StringRepresentation.VERSION_FULL) {
            sb.append(' ');
            sb.append('(');
            sb.append(this.buildTime().truncatedTo(ChronoUnit.SECONDS));
            sb.append(')');
        }
        return sb.toString();
    }
}

