/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.tags.internal;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.tags.TagRegistry;
import be.seeseemelk.mockbukkit.tags.internal.InternalTag;
import be.seeseemelk.mockbukkit.tags.internal.InternalTagMisconfigurationException;
import be.seeseemelk.mockbukkit.tags.internal.InternalTagRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;

public class InternalTagParser {
    private static final Pattern MINECRAFT_MATERIAL = Pattern.compile("minecraft:[a-z0-9_]+");
    private static final Pattern MINECRAFT_TAG = Pattern.compile("#minecraft:[a-z_]+");

    public void insertInternalTagValues(InternalTagRegistry internalTagRegistry) throws IOException, InternalTagMisconfigurationException {
        String path = "/internal_tags/" + internalTagRegistry.name().toLowerCase(Locale.ROOT) + "/";
        for (InternalTag<?> internalTag : internalTagRegistry.getRelatedTags()) {
            String filePath = path + internalTag.getName().toLowerCase(Locale.ROOT) + ".json";
            InputStream inputStream = MockBukkit.class.getResourceAsStream(filePath);
            try {
                if (inputStream == null) {
                    throw new IOException("Could not find resource: " + filePath);
                }
                JsonObject object = (JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(inputStream));
                this.parse(object, internalTagRegistry.getTagRegistryEquivalent(), internalTag);
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
    }

    private <T> void parse(JsonObject json, TagRegistry tagRegistry, InternalTag<T> internalTag) throws InternalTagMisconfigurationException {
        JsonArray taggedElements = (JsonArray)json.get("values");
        Set<T> included = this.parseJsonArray(taggedElements, tagRegistry, internalTag.getRelatedClass());
        internalTag.addValues(included);
    }

    private <T> Set<T> parseJsonArray(JsonArray array, TagRegistry tagRegistry, Class<T> targetClass) throws InternalTagMisconfigurationException {
        if (targetClass == Material.class) {
            EnumSet<Material> output = EnumSet.noneOf(Material.class);
            for (JsonElement element : array.asList()) {
                String aString = element.getAsString();
                if (MINECRAFT_TAG.matcher(aString).matches()) {
                    output.addAll(this.parseTag(aString.replace("^#", ""), tagRegistry));
                    continue;
                }
                if (MINECRAFT_MATERIAL.matcher(aString).matches()) {
                    output.add(this.parseMaterial(aString));
                    continue;
                }
                throw new InternalTagMisconfigurationException("Unexpected value format: " + aString);
            }
            return output;
        }
        throw new InternalTagMisconfigurationException("Unimplemented materialtype parsing of type name: " + targetClass.getName());
    }

    private Material parseMaterial(String materialString) throws InternalTagMisconfigurationException {
        Material material = Material.matchMaterial((String)materialString);
        if (material == null) {
            throw new InternalTagMisconfigurationException("Invalid namespace key " + materialString);
        }
        return material;
    }

    private Set<Material> parseTag(String tagString, TagRegistry tagRegistry) throws InternalTagMisconfigurationException {
        NamespacedKey namespacedKey = NamespacedKey.minecraft((String)tagString.split(":")[1]);
        Tag tag = tagRegistry.getTags().get(namespacedKey);
        if (tag == null) {
            throw new InternalTagMisconfigurationException("Invalid tag " + String.valueOf(namespacedKey));
        }
        return tag.getValues();
    }
}

