/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.util.io;

import be.seeseemelk.mockbukkit.inventory.ItemStackMock;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BukkitObjectInputStreamMock
extends ObjectInputStream {
    public BukkitObjectInputStreamMock(InputStream in) throws IOException {
        super(in);
        this.enableResolveObject(true);
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            if (map.containsKey("v") && map.containsKey("type")) {
                return this.deserializeItemStack(map);
            }
            if (map.containsKey("x") && map.containsKey("y") && map.containsKey("z") && map.containsKey("pitch") && map.containsKey("yaw")) {
                System.out.println("Deserializing location");
                return Location.deserialize((Map)map);
            }
        }
        return super.resolveObject(obj);
    }

    private ItemStack deserializeItemStack(Map<String, Object> map) throws IOException {
        ItemStack itemStack = ItemStackMock.deserialize(map);
        if (map.containsKey("meta")) {
            Class aClass = itemStack.getItemMeta().getClass();
            try {
                Method method = aClass.getDeclaredMethod("deserialize", Map.class);
                Map serializedMeta = (Map)map.get("meta");
                for (Map.Entry entry : new HashMap(serializedMeta).entrySet()) {
                    serializedMeta.put((String)entry.getKey(), this.resolveObject(entry.getValue()));
                }
                ItemMeta meta = (ItemMeta)method.invoke(null, serializedMeta);
                itemStack.setItemMeta(meta);
            }
            catch (ReflectiveOperationException e) {
                Logger.getLogger("BukkitObjectInputStreamMock").log(Level.WARNING, "Failed to deserialize ItemMeta for " + aClass.getName(), e);
            }
        }
        return itemStack;
    }
}

