/*
 * Decompiled with CFR 0.152.
 */
package com.github.selfancy.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.github.selfancy.apollo.DynamicPropertiesConfigBeanPostProcessor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetadata;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;

@ConditionalOnClass(value={Config.class})
@ConditionalOnProperty(value={"apollo.bootstrap.enabled"})
class DynamicPropertiesChangeBinderListener
implements ApplicationContextAware,
ApplicationListener<ApplicationStartedEvent>,
ConfigChangeListener,
Ordered {
    private Binder binder;
    private ConfigurationBeanFactoryMetadata beanFactoryMetadata;
    private String[] apolloNamespaces;
    private static final int ORDER = -2147483639;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicPropertiesChangeBinderListener.class);

    DynamicPropertiesChangeBinderListener() {
    }

    public int getOrder() {
        return -2147483639;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)applicationContext;
        ConfigurableEnvironment environment = context.getEnvironment();
        MutablePropertySources propertySources = environment.getPropertySources();
        this.binder = new Binder(ConfigurationPropertySources.from((Iterable)propertySources), (PlaceholdersResolver)new PropertySourcesPlaceholdersResolver((Iterable)propertySources), context.getBeanFactory().getConversionService(), arg_0 -> ((ConfigurableListableBeanFactory)context.getBeanFactory()).copyRegisteredEditorsTo(arg_0));
        this.apolloNamespaces = (String[])environment.getProperty("apollo.bootstrap.namespaces", String[].class, (Object)new String[]{"application"});
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        String[] namespaces = this.apolloNamespaces;
        Set<String> interestedKeyPrefixes = this.getConfigBeanMap().keySet();
        if (!interestedKeyPrefixes.isEmpty()) {
            for (String namespace : namespaces) {
                Config config = ConfigService.getConfig((String)namespace);
                config.addChangeListener((ConfigChangeListener)this, null, interestedKeyPrefixes);
            }
        }
    }

    public synchronized void onChange(ConfigChangeEvent changeEvent) {
        Set changedKeys = changeEvent.changedKeys();
        HashSet<String> refreshedKeys = new HashSet<String>();
        for (Map.Entry<String, Object> entry : this.getConfigBeanMap().entrySet()) {
            String propertiesPrefix = entry.getKey();
            for (String changedKey : changedKeys) {
                if (!changedKey.startsWith(propertiesPrefix) || refreshedKeys.contains(propertiesPrefix)) continue;
                Object bean = entry.getValue();
                this.refreshConfigPropertiesBean(propertiesPrefix, bean);
                LOGGER.info("Dynamic update apollo changed value successfully, refreshed bean {}.\n{}", (Object)bean.getClass().getName(), (Object)changedKeys.stream().filter(key -> key.startsWith(propertiesPrefix)).map(key -> changeEvent.getChange(key)).map(String::valueOf).collect(Collectors.joining("\n")));
                refreshedKeys.add(propertiesPrefix);
            }
        }
    }

    private <T> void refreshConfigPropertiesBean(String configPrefix, T bean) {
        Bindable target = Bindable.ofInstance(bean);
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        this.binder.bind(configPrefix, target, (BindHandler)handler);
    }

    private Map<String, Object> getConfigBeanMap() {
        return DynamicPropertiesConfigBeanPostProcessor.getConfigBeanMap();
    }
}

