/*
 * Decompiled with CFR 0.152.
 */
package com.github.selfancy.apollo;

import com.github.selfancy.apollo.DynamicProperties;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetadata;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;

class DynamicPropertiesConfigBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
InitializingBean,
Ordered {
    private ConfigurableApplicationContext applicationContext;
    private ConfigurationBeanFactoryMetadata beanFactoryMetadata;
    private static final Map<String, Object> configBeanMap = new ConcurrentHashMap<String, Object>();
    static final int ORDER = -2147483638;

    DynamicPropertiesConfigBeanPostProcessor() {
    }

    public int getOrder() {
        return -2147483638;
    }

    public void afterPropertiesSet() {
        this.beanFactoryMetadata = (ConfigurationBeanFactoryMetadata)this.applicationContext.getBean(ConfigurationBeanFactoryMetadata.BEAN_NAME, ConfigurationBeanFactoryMetadata.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        ConfigurationProperties configurationProperties = this.getAnnotation(bean, beanName, ConfigurationProperties.class);
        DynamicProperties dynamicProperties = this.getAnnotation(bean, beanName, DynamicProperties.class);
        if (configurationProperties != null && dynamicProperties != null) {
            configBeanMap.put(configurationProperties.prefix(), bean);
        }
        return bean;
    }

    private <A extends Annotation> A getAnnotation(Object bean, String beanName, Class<A> type) {
        Annotation annotation = this.beanFactoryMetadata.findFactoryAnnotation(beanName, type);
        if (annotation == null) {
            annotation = AnnotationUtils.findAnnotation(bean.getClass(), type);
        }
        return (A)annotation;
    }

    static Map<String, Object> getConfigBeanMap() {
        return configBeanMap;
    }
}

