/*
 * Decompiled with CFR 0.152.
 */
package awscala.emr;

import awscala.emr.EMR;
import com.amazonaws.regions.Region;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.Cluster;
import com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest;
import com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import com.amazonaws.services.elasticmapreduce.model.InstanceRoleType;
import com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig;
import com.amazonaws.services.elasticmapreduce.model.MarketType;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowResult;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest;
import java.util.Collection;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxedUnit;

public abstract class EMR$class {
    public static long CHECK_INTERVAL(EMR $this) {
        return 5000L;
    }

    public static EMR at(EMR $this, Region region) {
        $this.setRegion(region);
        return $this;
    }

    public static InstanceGroupConfig buildMasterGroupConfig(EMR $this, String masterInstanceType, String masterMarketType, String masterBidPrice) {
        MarketType masterMarketTypeObject = MarketType.fromValue((String)masterMarketType);
        InstanceGroupConfig masterGroupConfig = new InstanceGroupConfig().withName($this.masterGroupName()).withInstanceRole(InstanceRoleType.MASTER).withInstanceCount(Predef$.MODULE$.int2Integer(1)).withInstanceType(masterInstanceType).withMarket(masterMarketTypeObject);
        String string = masterMarketTypeObject.name();
        String string2 = "SPOT";
        Object object = !(string != null ? !string.equals(string2) : string2 != null) ? masterGroupConfig.withBidPrice(masterBidPrice) : BoxedUnit.UNIT;
        return masterGroupConfig;
    }

    public static String buildMasterGroupConfig$default$3(EMR $this) {
        return "0.0";
    }

    public static InstanceGroupConfig buildCoreGroupConfig(EMR $this, String coreInstanceType, int coreInstanceCount, String coreMarketType, String coreBidPrice) {
        MarketType corerMarketTypeObject = MarketType.fromValue((String)coreMarketType);
        InstanceGroupConfig coreGroupConfig = new InstanceGroupConfig().withName($this.coreGroupName()).withInstanceRole(InstanceRoleType.CORE).withInstanceType(coreInstanceType).withInstanceCount(Predef$.MODULE$.int2Integer(coreInstanceCount)).withMarket(corerMarketTypeObject);
        String string = corerMarketTypeObject.name();
        String string2 = "SPOT";
        Object object = !(string != null ? !string.equals(string2) : string2 != null) ? coreGroupConfig.withBidPrice(coreBidPrice) : BoxedUnit.UNIT;
        return coreGroupConfig;
    }

    public static String buildCoreGroupConfig$default$4(EMR $this) {
        return "0.0";
    }

    public static InstanceGroupConfig buildTaskGroupConfig(EMR $this, String taskInstanceType, int taskInstanceCount, String taskMarketType, String taskBidPrice) {
        MarketType taskMarketTypeObject = MarketType.fromValue((String)taskMarketType);
        InstanceGroupConfig taskGroupConfig = new InstanceGroupConfig().withName($this.taskGroupName()).withInstanceRole(InstanceRoleType.TASK).withInstanceType(taskInstanceType).withInstanceCount(Predef$.MODULE$.int2Integer(taskInstanceCount)).withMarket(taskMarketTypeObject);
        String string = taskMarketTypeObject.name();
        String string2 = "SPOT";
        Object object = !(string != null ? !string.equals(string2) : string2 != null) ? taskGroupConfig.withBidPrice(taskBidPrice) : BoxedUnit.UNIT;
        return taskGroupConfig;
    }

    public static String buildTaskGroupConfig$default$4(EMR $this) {
        return "0.0";
    }

    public static JobFlowInstancesConfig buildJobFlowInstancesConfig(EMR $this, String masterInstanceType, String masterMarketType, String masterBidPrice, String coreInstanceType, int coreInstanceCount, String coreMarketType, String coreBidPrice, String taskInstanceType, int taskInstanceCount, String taskMarketType, String taskBidPrice, String ec2KeyName, String hadoopVersion) {
        InstanceGroupConfig masterGroupConfig = $this.buildMasterGroupConfig(masterInstanceType, masterMarketType, masterBidPrice);
        InstanceGroupConfig coreGroupConfig = $this.buildCoreGroupConfig(coreInstanceType, coreInstanceCount, coreMarketType, coreBidPrice);
        InstanceGroupConfig taskGroupConfig = $this.buildTaskGroupConfig(taskInstanceType, taskInstanceCount, taskMarketType, taskBidPrice);
        List clusterGroups = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InstanceGroupConfig[]{masterGroupConfig, coreGroupConfig, taskGroupConfig}));
        AddInstanceGroupsRequest addInstanceGroupsRequest = new AddInstanceGroupsRequest().withInstanceGroups((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)clusterGroups));
        return new JobFlowInstancesConfig().withEc2KeyName(ec2KeyName).withHadoopVersion(hadoopVersion).withInstanceGroups((Collection)addInstanceGroupsRequest.getInstanceGroups());
    }

    public static String buildJobFlowInstancesConfig$default$1(EMR $this) {
        return "m1.small";
    }

    public static String buildJobFlowInstancesConfig$default$2(EMR $this) {
        return "ON_DEMAND";
    }

    public static String buildJobFlowInstancesConfig$default$3(EMR $this) {
        return "0.0";
    }

    public static String buildJobFlowInstancesConfig$default$4(EMR $this) {
        return "m1.small";
    }

    public static int buildJobFlowInstancesConfig$default$5(EMR $this) {
        return 1;
    }

    public static String buildJobFlowInstancesConfig$default$6(EMR $this) {
        return "ON_DEMAND";
    }

    public static String buildJobFlowInstancesConfig$default$7(EMR $this) {
        return "0.0";
    }

    public static String buildJobFlowInstancesConfig$default$8(EMR $this) {
        return "m1.small";
    }

    public static int buildJobFlowInstancesConfig$default$9(EMR $this) {
        return 1;
    }

    public static String buildJobFlowInstancesConfig$default$10(EMR $this) {
        return "ON_DEMAND";
    }

    public static String buildJobFlowInstancesConfig$default$11(EMR $this) {
        return "0.0";
    }

    public static AddJobFlowStepsRequest buildJobFlowStepsRequest(EMR $this, List steps, String jobFlowId) {
        List stepConfig = EMR$class.buildSteps($this, steps);
        AddJobFlowStepsRequest addJobFlowStepsRequest = new AddJobFlowStepsRequest().withSteps((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)stepConfig));
        String string = jobFlowId;
        String string2 = "";
        Object object = !(string != null ? !string.equals(string2) : string2 != null) ? BoxedUnit.UNIT : addJobFlowStepsRequest.withJobFlowId(jobFlowId);
        return addJobFlowStepsRequest;
    }

    public static String buildJobFlowStepsRequest$default$2(EMR $this) {
        return "";
    }

    private static List buildSteps(EMR $this, List steps) {
        return (List)((List)steps.map((Function1)new Serializable($this){

            public final Tuple3<EMR.jarStep, HadoopJarStepConfig, StepConfig> apply(EMR.jarStep step) {
                HadoopJarStepConfig aStepConfigJar = new HadoopJarStepConfig(step.stepPath()).withMainClass(step.stepClass()).withArgs((Collection)JavaConversions$.MODULE$.seqAsJavaList(step.stepArgs()));
                StepConfig aStepConfig = new StepConfig().withName(step.stepName()).withHadoopJarStep(aStepConfigJar);
                return new Tuple3((Object)step, (Object)aStepConfigJar, (Object)aStepConfig);
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this){

            public final StepConfig apply(Tuple3<EMR.jarStep, HadoopJarStepConfig, StepConfig> x$1) {
                Tuple3<EMR.jarStep, HadoopJarStepConfig, StepConfig> tuple3 = x$1;
                if (tuple3 != null) {
                    StepConfig aStepConfig;
                    StepConfig stepConfig = aStepConfig = (StepConfig)tuple3._3();
                    return stepConfig;
                }
                throw new MatchError(tuple3);
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public static RunJobFlowRequest buildRunRequest(EMR $this, String jobName, String amiVersion, String loggingURI, boolean visibleToAllUsers, JobFlowInstancesConfig jobFlowInstancesConfig, AddJobFlowStepsRequest jobFlowStepsRequest) {
        return new RunJobFlowRequest().withName(jobName).withAmiVersion(amiVersion).withSteps((Collection)jobFlowStepsRequest.getSteps()).withLogUri(loggingURI).withVisibleToAllUsers(Predef$.MODULE$.boolean2Boolean(visibleToAllUsers)).withInstances(jobFlowInstancesConfig);
    }

    public static String buildRunRequest$default$1(EMR $this) {
        return "AWSscala";
    }

    public static String buildRunRequest$default$2(EMR $this) {
        return "latest";
    }

    public static String buildRunRequest$default$3(EMR $this) {
        return "";
    }

    public static boolean buildRunRequest$default$4(EMR $this) {
        return true;
    }

    public static RunJobFlowResult runJobFlow(EMR $this, String masterInstanceType, String masterMarketType, String masterBidPrice, String coreInstanceType, int coreInstanceCount, String coreMarketType, String coreBidPrice, String taskInstanceType, int taskInstanceCount, String taskMarketType, String taskBidPrice, String ec2KeyName, String hadoopVersion, List steps, String jobFlowId, String jobName, String amiVersion, String loggingURI, boolean visibleToAllUsers) {
        JobFlowInstancesConfig jobFlowInstancesConfig = $this.buildJobFlowInstancesConfig(masterInstanceType, masterMarketType, masterBidPrice, coreInstanceType, coreInstanceCount, coreMarketType, coreBidPrice, taskInstanceType, taskInstanceCount, taskMarketType, taskBidPrice, ec2KeyName, hadoopVersion);
        AddJobFlowStepsRequest jobFlowStepsRequest = $this.buildJobFlowStepsRequest(steps, jobFlowId);
        RunJobFlowRequest runJobFlowRequest = $this.buildRunRequest(jobName, amiVersion, loggingURI, visibleToAllUsers, jobFlowInstancesConfig, jobFlowStepsRequest);
        return $this.runJobFlow(runJobFlowRequest);
    }

    public static String runJobFlow$default$1(EMR $this) {
        return "m1.small";
    }

    public static String runJobFlow$default$2(EMR $this) {
        return "ON_DEMAND";
    }

    public static String runJobFlow$default$3(EMR $this) {
        return "0.0";
    }

    public static String runJobFlow$default$4(EMR $this) {
        return "m1.small";
    }

    public static int runJobFlow$default$5(EMR $this) {
        return 1;
    }

    public static String runJobFlow$default$6(EMR $this) {
        return "ON_DEMAND";
    }

    public static String runJobFlow$default$7(EMR $this) {
        return "0.0";
    }

    public static String runJobFlow$default$8(EMR $this) {
        return "m1.small";
    }

    public static int runJobFlow$default$9(EMR $this) {
        return 1;
    }

    public static String runJobFlow$default$10(EMR $this) {
        return "ON_DEMAND";
    }

    public static String runJobFlow$default$11(EMR $this) {
        return "0.0";
    }

    public static String runJobFlow$default$15(EMR $this) {
        return "";
    }

    public static String runJobFlow$default$16(EMR $this) {
        return "AWSscala";
    }

    public static String runJobFlow$default$17(EMR $this) {
        return "latest";
    }

    public static String runJobFlow$default$18(EMR $this) {
        return "";
    }

    public static boolean runJobFlow$default$19(EMR $this) {
        return true;
    }

    public static Object getClusterDetail(EMR $this, String jobFlowId, Function1 op) {
        DescribeClusterRequest describeClusterRequest = new DescribeClusterRequest().withClusterId(jobFlowId);
        Cluster cluster2 = $this.describeCluster(describeClusterRequest).getCluster();
        return op.apply((Object)cluster2);
    }

    public static String getClusterState(EMR $this, String jobFlowId) {
        return (String)$this.getClusterDetail(jobFlowId, new Serializable($this){
            private final /* synthetic */ EMR $outer;

            public final String apply(Cluster cluster2) {
                return EMR$class.getState$1(this.$outer, cluster2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static String getClusterName(EMR $this, String jobFlowId) {
        return (String)$this.getClusterDetail(jobFlowId, new Serializable($this){
            private final /* synthetic */ EMR $outer;

            public final String apply(Cluster cluster2) {
                return EMR$class.getName$1(this.$outer, cluster2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static String terminateCluster(EMR $this, String jobFlowId) {
        return (String)new TerminateJobFlowsRequest().withJobFlowIds(new String[]{jobFlowId}).getJobFlowIds().get(0);
    }

    public static final String getState$1(EMR $this, Cluster cluster2) {
        return cluster2.getStatus().getState();
    }

    public static final String getName$1(EMR $this, Cluster cluster2) {
        return cluster2.getName();
    }

    public static void $init$(EMR $this) {
        $this.awscala$emr$EMR$_setter_$masterGroupName_$eq("Master");
        $this.awscala$emr$EMR$_setter_$coreGroupName_$eq("Core");
        $this.awscala$emr$EMR$_setter_$taskGroupName_$eq("Task");
    }
}

