/*
 * Decompiled with CFR 0.152.
 */
package awscala.s3;

import awscala.Region$;
import awscala.s3.AccessControlList;
import awscala.s3.AccessControlList$;
import awscala.s3.Bucket;
import awscala.s3.Bucket$;
import awscala.s3.BucketCrossOriginConfiguration;
import awscala.s3.BucketCrossOriginConfiguration$;
import awscala.s3.BucketLifecycleConfiguration;
import awscala.s3.BucketLifecycleConfiguration$;
import awscala.s3.BucketLoggingConfiguration;
import awscala.s3.BucketLoggingConfiguration$;
import awscala.s3.BucketNotificationConfiguration;
import awscala.s3.BucketNotificationConfiguration$;
import awscala.s3.BucketPolicy;
import awscala.s3.BucketPolicy$;
import awscala.s3.BucketTaggingConfiguration;
import awscala.s3.BucketTaggingConfiguration$;
import awscala.s3.BucketVersioningConfiguration;
import awscala.s3.BucketVersioningConfiguration$;
import awscala.s3.BucketWebsiteConfiguration;
import awscala.s3.BucketWebsiteConfiguration$;
import awscala.s3.Owner;
import awscala.s3.Owner$;
import awscala.s3.PutObjectResult;
import awscala.s3.PutObjectResult$;
import awscala.s3.S3;
import awscala.s3.S3Object;
import awscala.s3.S3Object$;
import awscala.s3.S3ObjectSummary;
import awscala.s3.S3ObjectSummary$;
import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.DeleteVersionRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.joda.time.DateTime;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;

public abstract class S3$class {
    public static S3 at(S3 $this, Region region) {
        $this.setRegion(region);
        $this.awscala$s3$S3$$region_$eq(com.amazonaws.services.s3.model.Region.fromValue((String)region.getName()));
        return $this;
    }

    public static Owner s3AccountOwner(S3 $this) {
        return Owner$.MODULE$.apply($this.getS3AccountOwner());
    }

    public static Seq buckets(S3 $this) {
        return (Seq)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listBuckets()).asScala()).toSeq().map((Function1)new Serializable($this){

            public final Bucket apply(com.amazonaws.services.s3.model.Bucket b) {
                return Bucket$.MODULE$.apply(b);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Option bucket(S3 $this, String name) {
        return $this.buckets().find((Function1)new Serializable($this, name){
            private final String name$1;

            public final boolean apply(Bucket x$1) {
                String string = x$1.name();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.name$1 = name$1;
            }
        });
    }

    public static AccessControlList acl(S3 $this, Bucket bucket2) {
        return $this.bucketAcl(bucket2.name());
    }

    public static AccessControlList bucketAcl(S3 $this, String name) {
        return AccessControlList$.MODULE$.apply($this.getBucketAcl(name));
    }

    public static void bucketAcl(S3 $this, Bucket bucket2, AccessControlList acl) {
        $this.setBucketAcl(bucket2.name(), acl);
    }

    public static String location(S3 $this, Bucket bucket2) {
        return $this.getBucketLocation(bucket2.name());
    }

    public static BucketCrossOriginConfiguration crossOriginConfig(S3 $this, Bucket bucket2) {
        return BucketCrossOriginConfiguration$.MODULE$.apply(bucket2, $this.getBucketCrossOriginConfiguration(bucket2.name()));
    }

    public static BucketLifecycleConfiguration lifecycleConfig(S3 $this, Bucket bucket2) {
        return BucketLifecycleConfiguration$.MODULE$.apply(bucket2, $this.getBucketLifecycleConfiguration(bucket2.name()));
    }

    public static BucketPolicy policy(S3 $this, Bucket bucket2) {
        return BucketPolicy$.MODULE$.apply(bucket2, $this.getBucketPolicy(bucket2.name()));
    }

    public static BucketLoggingConfiguration loggingConfig(S3 $this, Bucket bucket2) {
        return BucketLoggingConfiguration$.MODULE$.apply($this.getBucketLoggingConfiguration(bucket2.name()));
    }

    public static BucketNotificationConfiguration notificationConfig(S3 $this, Bucket bucket2) {
        return BucketNotificationConfiguration$.MODULE$.apply(bucket2, $this.getBucketNotificationConfiguration(bucket2.name()));
    }

    public static BucketTaggingConfiguration taggingConfig(S3 $this, Bucket bucket2) {
        return BucketTaggingConfiguration$.MODULE$.apply(bucket2, $this.getBucketTaggingConfiguration(bucket2.name()));
    }

    public static BucketVersioningConfiguration versioningConfig(S3 $this, Bucket bucket2) {
        return BucketVersioningConfiguration$.MODULE$.apply(bucket2, $this.getBucketVersioningConfiguration(bucket2.name()));
    }

    public static BucketWebsiteConfiguration websiteConfig(S3 $this, Bucket bucket2) {
        return BucketWebsiteConfiguration$.MODULE$.apply(bucket2, $this.getBucketWebsiteConfiguration(bucket2.name()));
    }

    public static Bucket createBucket(S3 $this, String name) {
        return Bucket$.MODULE$.apply($this.createBucket(new CreateBucketRequest(name, $this.awscala$s3$S3$$region())));
    }

    public static void delete(S3 $this, Bucket bucket2) {
        $this.deleteBucket(bucket2);
    }

    public static void deleteBucket(S3 $this, Bucket bucket2) {
        $this.deleteBucket(bucket2.name());
    }

    public static void deleteCrossOriginConfig(S3 $this, Bucket bucket2) {
        $this.deleteBucketCrossOriginConfiguration(bucket2.name());
    }

    public static void deleteLifecycleConfig(S3 $this, Bucket bucket2) {
        $this.deleteBucketLifecycleConfiguration(bucket2.name());
    }

    public static void deletePolicy(S3 $this, Bucket bucket2) {
        $this.deleteBucketPolicy(bucket2.name());
    }

    public static void deleteTaggingConfig(S3 $this, Bucket bucket2) {
        $this.deleteBucketTaggingConfiguration(bucket2.name());
    }

    public static void deleteWebsiteConfig(S3 $this, Bucket bucket2) {
        $this.deleteBucketWebsiteConfiguration(bucket2.name());
    }

    public static Option get(S3 $this, Bucket bucket2, String key) {
        return $this.getObject(bucket2, key);
    }

    public static Option get(S3 $this, Bucket bucket2, String key, String versionId) {
        return $this.getObject(bucket2, key, versionId);
    }

    public static Option getObject(S3 $this, Bucket bucket2, String key) {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply((Object)$this.getObject(new GetObjectRequest(bucket2.name(), key))).map((Function1)new Serializable($this, bucket2){
                private final Bucket bucket$1;

                public final S3Object apply(com.amazonaws.services.s3.model.S3Object obj) {
                    return S3Object$.MODULE$.apply(this.bucket$1, obj);
                }
                {
                    this.bucket$1 = bucket$1;
                }
            });
        }
        catch (AmazonS3Exception amazonS3Exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static Option getObject(S3 $this, Bucket bucket2, String key, String versionId) {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply((Object)$this.getObject(new GetObjectRequest(bucket2.name(), key, versionId))).map((Function1)new Serializable($this, bucket2){
                private final Bucket bucket$2;

                public final S3Object apply(com.amazonaws.services.s3.model.S3Object obj) {
                    return S3Object$.MODULE$.apply(this.bucket$2, obj);
                }
                {
                    this.bucket$2 = bucket$2;
                }
            });
        }
        catch (AmazonS3Exception amazonS3Exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static ObjectMetadata metadata(S3 $this, Bucket bucket2, String key) {
        return $this.getObjectMetadata(bucket2.name(), key);
    }

    public static Seq objectSummaries(S3 $this, Bucket bucket2) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listObjects(bucket2.name()).getObjectSummaries()).asScala()).map((Function1)new Serializable($this, bucket2){
            private final Bucket bucket$3;

            public final S3ObjectSummary apply(com.amazonaws.services.s3.model.S3ObjectSummary s) {
                return S3ObjectSummary$.MODULE$.apply(this.bucket$3, s);
            }
            {
                this.bucket$3 = bucket$3;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static Seq objectSummaries(S3 $this, Bucket bucket2, String prefix) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listObjects(bucket2.name(), prefix).getObjectSummaries()).asScala()).map((Function1)new Serializable($this, bucket2){
            private final Bucket bucket$4;

            public final S3ObjectSummary apply(com.amazonaws.services.s3.model.S3ObjectSummary s) {
                return S3ObjectSummary$.MODULE$.apply(this.bucket$4, s);
            }
            {
                this.bucket$4 = bucket$4;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static Seq keys(S3 $this, Bucket bucket2) {
        return (Seq)$this.objectSummaries(bucket2).map((Function1)new Serializable($this){

            public final String apply(S3ObjectSummary os) {
                return os.getKey();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq keys(S3 $this, Bucket bucket2, String prefix) {
        return (Seq)$this.objectSummaries(bucket2, prefix).map((Function1)new Serializable($this){

            public final String apply(S3ObjectSummary os) {
                return os.getKey();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static AccessControlList acl(S3 $this, S3Object obj) {
        return $this.acl(obj.bucket(), obj.key());
    }

    public static AccessControlList acl(S3 $this, Bucket bucket2, String key) {
        return AccessControlList$.MODULE$.apply($this.getObjectAcl(bucket2.name(), key));
    }

    public static void acl(S3 $this, S3Object obj, AccessControlList acl) {
        $this.setObjectAcl(obj.bucket().name(), obj.key(), acl);
    }

    public static void acl(S3 $this, S3Object obj, CannedAccessControlList acl) {
        $this.setObjectAcl(obj.bucket().name(), obj.key(), acl);
    }

    public static void acl(S3 $this, Bucket bucket2, String key, AccessControlList acl) {
        $this.setObjectAcl(bucket2.name(), key, acl);
    }

    public static void acl(S3 $this, Bucket bucket2, String key, CannedAccessControlList acl) {
        $this.setObjectAcl(bucket2.name(), key, acl);
    }

    public static PutObjectResult put(S3 $this, Bucket bucket2, String key, File file) {
        return $this.putObject(bucket2, key, file);
    }

    public static PutObjectResult putAsPublicRead(S3 $this, Bucket bucket2, String key, File file) {
        return $this.putObjectAsPublicRead(bucket2, key, file);
    }

    public static PutObjectResult putAsPublicReadWrite(S3 $this, Bucket bucket2, String key, File file) {
        return $this.putObjectAsPublicReadWrite(bucket2, key, file);
    }

    public static PutObjectResult putObject(S3 $this, Bucket bucket2, String key, File file) {
        return PutObjectResult$.MODULE$.apply(bucket2, key, $this.putObject(bucket2.name(), key, file));
    }

    public static PutObjectResult putObjectAsPublicRead(S3 $this, Bucket bucket2, String key, File file) {
        return PutObjectResult$.MODULE$.apply(bucket2, key, $this.putObject(new PutObjectRequest(bucket2.name(), key, file).withCannedAcl(CannedAccessControlList.PublicRead)));
    }

    public static PutObjectResult putObjectAsPublicReadWrite(S3 $this, Bucket bucket2, String key, File file) {
        return PutObjectResult$.MODULE$.apply(bucket2, key, $this.putObject(new PutObjectRequest(bucket2.name(), key, file).withCannedAcl(CannedAccessControlList.PublicReadWrite)));
    }

    public static PutObjectResult put(S3 $this, Bucket bucket2, String key, byte[] bytes, ObjectMetadata metadata) {
        return $this.putObject(bucket2, key, bytes, metadata);
    }

    public static PutObjectResult putAsPublicRead(S3 $this, Bucket bucket2, String key, byte[] bytes, ObjectMetadata metadata) {
        return $this.putObjectAsPublicRead(bucket2, key, bytes, metadata);
    }

    public static PutObjectResult putObject(S3 $this, Bucket bucket2, String key, byte[] bytes, ObjectMetadata metadata) {
        return PutObjectResult$.MODULE$.apply(bucket2, key, $this.putObject(new PutObjectRequest(bucket2.name(), key, (InputStream)new ByteArrayInputStream(bytes), metadata)));
    }

    public static PutObjectResult putObjectAsPublicRead(S3 $this, Bucket bucket2, String key, byte[] bytes, ObjectMetadata metadata) {
        return PutObjectResult$.MODULE$.apply(bucket2, key, $this.putObject(new PutObjectRequest(bucket2.name(), key, (InputStream)new ByteArrayInputStream(bytes), metadata).withCannedAcl(CannedAccessControlList.PublicRead)));
    }

    public static PutObjectResult copy(S3 $this, S3Object from, S3Object to) {
        return $this.copyObject(from, to);
    }

    public static PutObjectResult copyObject(S3 $this, S3Object from, S3Object to) {
        CopyObjectResult result = $this.copyObject(from.bucket().name(), from.key(), to.bucket().name(), to.key());
        return PutObjectResult$.MODULE$.apply(to.bucket(), to.key(), result);
    }

    public static void delete(S3 $this, S3Object obj) {
        $this.deleteObject(obj);
    }

    public static void deleteObject(S3 $this, S3Object obj) {
        $this.deleteObject(obj.bucket().name(), obj.key());
    }

    public static void deleteVersion(S3 $this, S3Object obj, String versionId) {
        $this.deleteObjectVersion(obj, versionId);
    }

    public static void deleteObjectVersion(S3 $this, S3Object obj, String versionId) {
        $this.deleteVersion(new DeleteVersionRequest(obj.bucket().name(), obj.key(), versionId));
    }

    public static void deleteObjects(S3 $this, Seq objs) {
        objs.headOption().map((Function1)new Serializable($this, objs){
            private final /* synthetic */ S3 $outer;
            private final Seq objs$1;

            public final DeleteObjectsResult apply(S3Object obj) {
                DeleteObjectsRequest req = new DeleteObjectsRequest(obj.bucket().name());
                req.setKeys((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.objs$1.map((Function1)new Serializable(this){

                    public final DeleteObjectsRequest.KeyVersion apply(S3Object obj) {
                        return new DeleteObjectsRequest.KeyVersion(obj.key(), obj.versionId());
                    }
                }, Seq$.MODULE$.canBuildFrom())).asJava());
                return this.$outer.deleteObjects(req);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.objs$1 = objs$1;
            }
        });
    }

    public static URL generatePresignedUrl(S3 $this, S3Object obj, DateTime expiration) {
        return $this.generatePresignedUrl(obj.bucket().name(), obj.key(), expiration.toDate());
    }

    public static void $init$(S3 $this) {
        $this.awscala$s3$S3$$region_$eq(com.amazonaws.services.s3.model.Region.fromValue((String)Region$.MODULE$.default().getName()));
    }
}

