/*
 * Decompiled with CFR 0.152.
 */
package awscala.iam;

import awscala.Policy;
import awscala.iam.AccessKey;
import awscala.iam.AccessKey$;
import awscala.iam.Group;
import awscala.iam.Group$;
import awscala.iam.GroupPolicy;
import awscala.iam.GroupPolicy$;
import awscala.iam.IAM;
import awscala.iam.InstanceProfile;
import awscala.iam.InstanceProfile$;
import awscala.iam.LoginProfile;
import awscala.iam.LoginProfile$;
import awscala.iam.Role;
import awscala.iam.Role$;
import awscala.iam.RolePolicy;
import awscala.iam.RolePolicy$;
import awscala.iam.User;
import awscala.iam.User$;
import awscala.iam.UserPolicy;
import awscala.iam.UserPolicy$;
import awscala.iam.VirtualMFADevice;
import awscala.iam.VirtualMFADevice$;
import com.amazonaws.services.identitymanagement.model.AccessKeyMetadata;
import com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest;
import com.amazonaws.services.identitymanagement.model.ChangePasswordRequest;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.CreateAccountAliasRequest;
import com.amazonaws.services.identitymanagement.model.CreateGroupRequest;
import com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.CreateLoginProfileRequest;
import com.amazonaws.services.identitymanagement.model.CreateRoleRequest;
import com.amazonaws.services.identitymanagement.model.CreateUserRequest;
import com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceRequest;
import com.amazonaws.services.identitymanagement.model.DeactivateMFADeviceRequest;
import com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteAccountAliasRequest;
import com.amazonaws.services.identitymanagement.model.DeleteGroupPolicyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteGroupRequest;
import com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.DeleteLoginProfileRequest;
import com.amazonaws.services.identitymanagement.model.DeleteRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteRoleRequest;
import com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteUserRequest;
import com.amazonaws.services.identitymanagement.model.DeleteVirtualMFADeviceRequest;
import com.amazonaws.services.identitymanagement.model.EnableMFADeviceRequest;
import com.amazonaws.services.identitymanagement.model.GetGroupPolicyRequest;
import com.amazonaws.services.identitymanagement.model.GetGroupRequest;
import com.amazonaws.services.identitymanagement.model.GetLoginProfileRequest;
import com.amazonaws.services.identitymanagement.model.GetRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.GetUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.GetUserRequest;
import com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest;
import com.amazonaws.services.identitymanagement.model.ListGroupPoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListGroupsForUserRequest;
import com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleRequest;
import com.amazonaws.services.identitymanagement.model.ListMFADevicesRequest;
import com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest;
import com.amazonaws.services.identitymanagement.model.MFADevice;
import com.amazonaws.services.identitymanagement.model.NoSuchEntityException;
import com.amazonaws.services.identitymanagement.model.PutGroupPolicyRequest;
import com.amazonaws.services.identitymanagement.model.PutRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest;
import com.amazonaws.services.identitymanagement.model.StatusType;
import com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.UpdateGroupRequest;
import com.amazonaws.services.identitymanagement.model.UpdateLoginProfileRequest;
import com.amazonaws.services.identitymanagement.model.UpdateUserRequest;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;

public abstract class IAM$class {
    public static void changePassword(IAM $this, String oldPassword, String newPassword) {
        $this.changePassword(new ChangePasswordRequest().withOldPassword(oldPassword).withNewPassword(newPassword));
    }

    public static Seq accountAliases(IAM $this) {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter($this.listAccountAliases().getAccountAliases()).asScala();
    }

    public static void createAccountAlias(IAM $this, String alias) {
        $this.createAccountAlias(new CreateAccountAliasRequest().withAccountAlias(alias));
    }

    public static void deleteAccountAlias(IAM $this, String alias) {
        $this.deleteAccountAlias(new DeleteAccountAliasRequest().withAccountAlias(alias));
    }

    public static Seq groups(IAM $this) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listGroups().getGroups()).asScala()).map((Function1)new Serializable($this){

            public final Group apply(com.amazonaws.services.identitymanagement.model.Group g) {
                return Group$.MODULE$.apply(g);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static Seq groups(IAM $this, User user) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listGroupsForUser(new ListGroupsForUserRequest().withUserName(user.name())).getGroups()).asScala()).map((Function1)new Serializable($this){

            public final Group apply(com.amazonaws.services.identitymanagement.model.Group g) {
                return Group$.MODULE$.apply(g);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static Option group(IAM $this, String name) {
        Some some;
        try {
            some = new Some((Object)Group$.MODULE$.apply($this.getGroup(new GetGroupRequest(name)).getGroup()));
        }
        catch (NoSuchEntityException noSuchEntityException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public static Group createGroup(IAM $this, String name) {
        return Group$.MODULE$.apply($this.createGroup(new CreateGroupRequest(name)).getGroup());
    }

    public static void updateGroupPath(IAM $this, Group group, String newPath) {
        $this.updateGroup(new UpdateGroupRequest().withGroupName(group.name()).withNewPath(newPath));
    }

    public static void updateGroupName(IAM $this, Group group, String newName) {
        $this.updateGroup(new UpdateGroupRequest().withGroupName(group.name()).withNewGroupName(newName));
    }

    public static void addUserToGroup(IAM $this, Group group, User user) {
        $this.addUserToGroup(new AddUserToGroupRequest(group.name(), user.name()));
    }

    public static void removeUserFromGroup(IAM $this, Group group, User user) {
        $this.removeUserFromGroup(new RemoveUserFromGroupRequest().withGroupName(group.name()).withUserName(user.name()));
    }

    public static void delete(IAM $this, Group group) {
        $this.deleteGroup(group);
    }

    public static void deleteGroup(IAM $this, Group group) {
        $this.deleteGroup(new DeleteGroupRequest(group.name()));
    }

    public static Seq policyNames(IAM $this, Group group) {
        return $this.groupPolicyNames(group);
    }

    public static Seq groupPolicyNames(IAM $this, Group group) {
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listGroupPolicies(new ListGroupPoliciesRequest().withGroupName(group.name())).getPolicyNames()).asScala()).toSeq();
    }

    public static GroupPolicy groupPolicy(IAM $this, Group group, String policyName) {
        return GroupPolicy$.MODULE$.apply(group, $this.getGroupPolicy(new GetGroupPolicyRequest().withGroupName(group.name()).withPolicyName(policyName)));
    }

    public static void put(IAM $this, GroupPolicy policy) {
        $this.putGroupPolicy(policy);
    }

    public static void putGroupPolicy(IAM $this, GroupPolicy policy) {
        $this.putGroupPolicy(policy.group(), policy.name(), policy.document());
    }

    public static void putGroupPolicy(IAM $this, Group group, String policyName, Policy policy) {
        $this.putGroupPolicy(group, policyName, policy.toJSON());
    }

    public static void putGroupPolicy(IAM $this, Group group, String policyName, String policyDocument) {
        $this.putGroupPolicy(new PutGroupPolicyRequest().withGroupName(group.name()).withPolicyName(policyName).withPolicyDocument(policyDocument));
    }

    public static void delete(IAM $this, GroupPolicy policy) {
        $this.deleteGroupPolicy(policy);
    }

    public static void deleteGroupPolicy(IAM $this, GroupPolicy policy) {
        $this.deleteGroupPolicy(new DeleteGroupPolicyRequest().withGroupName(policy.group().name()).withPolicyName(policy.name()));
    }

    public static Seq users(IAM $this) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listUsers().getUsers()).asScala()).map((Function1)new Serializable($this){

            public final User apply(com.amazonaws.services.identitymanagement.model.User u) {
                return User$.MODULE$.apply(u);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static Option user(IAM $this, String name) {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply((Object)User$.MODULE$.apply($this.getUser(new GetUserRequest().withUserName(name)).getUser()));
        }
        catch (NoSuchEntityException noSuchEntityException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static User createUser(IAM $this, String name) {
        return User$.MODULE$.apply($this.createUser(new CreateUserRequest(name)).getUser());
    }

    public static void updateUserName(IAM $this, User user, String newName) {
        $this.updateUser(new UpdateUserRequest().withUserName(user.name()).withNewUserName(newName));
    }

    public static void updateUserPath(IAM $this, User user, String newPath) {
        $this.updateUser(new UpdateUserRequest().withUserName(user.name()).withNewPath(newPath));
    }

    public static void delete(IAM $this, User user) {
        $this.deleteUser(user);
    }

    public static void deleteUser(IAM $this, User user) {
        $this.deleteUser(new DeleteUserRequest(user.name()));
    }

    public static Seq policyNames(IAM $this, User user) {
        return $this.userPolicyNames(user);
    }

    public static Seq userPolicyNames(IAM $this, User user) {
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listUserPolicies(new ListUserPoliciesRequest().withUserName(user.name())).getPolicyNames()).asScala()).toSeq();
    }

    public static void put(IAM $this, UserPolicy policy) {
        $this.putUserPolicy(policy);
    }

    public static void putUserPolicy(IAM $this, UserPolicy policy) {
        $this.putUserPolicy(policy.user(), policy.name(), policy.document());
    }

    public static void putUserPolicy(IAM $this, User user, String policyName, String policyDocument) {
        $this.putUserPolicy(new PutUserPolicyRequest().withUserName(user.name()).withPolicyName(policyName).withPolicyDocument(policyDocument));
    }

    public static Option userPolicy(IAM $this, User user, String policyName) {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply((Object)UserPolicy$.MODULE$.apply(user, $this.getUserPolicy(new GetUserPolicyRequest().withUserName(user.name()).withPolicyName(policyName))));
        }
        catch (NoSuchEntityException noSuchEntityException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static void delete(IAM $this, UserPolicy policy) {
        $this.deleteUserPolicy(policy);
    }

    public static void deleteUserPolicy(IAM $this, UserPolicy policy) {
        $this.deleteUserPolicy(new DeleteUserPolicyRequest().withUserName(policy.user().name()).withPolicyName(policy.name()));
    }

    public static Seq accessKeys(IAM $this) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listAccessKeys().getAccessKeyMetadata()).asScala()).map((Function1)new Serializable($this){

            public final AccessKey apply(AccessKeyMetadata meta) {
                return AccessKey$.MODULE$.apply(meta);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static Seq accessKeys(IAM $this, User user) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listAccessKeys(new ListAccessKeysRequest().withUserName(user.name())).getAccessKeyMetadata()).asScala()).map((Function1)new Serializable($this){

            public final AccessKey apply(AccessKeyMetadata meta) {
                return AccessKey$.MODULE$.apply(meta);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static AccessKey createAccessKey(IAM $this, User user) {
        return AccessKey$.MODULE$.apply($this.createAccessKey(new CreateAccessKeyRequest().withUserName(user.name())).getAccessKey());
    }

    public static void activateAccessKey(IAM $this, AccessKey accessKey) {
        $this.updateAccessKey(new UpdateAccessKeyRequest().withAccessKeyId(accessKey.accessKeyId()).withStatus(StatusType.Active));
    }

    public static void inactivateAccessKey(IAM $this, AccessKey accessKey) {
        $this.updateAccessKey(new UpdateAccessKeyRequest().withAccessKeyId(accessKey.accessKeyId()).withStatus(StatusType.Inactive));
    }

    public static void delete(IAM $this, AccessKey accessKey) {
        $this.deleteAccessKey(accessKey);
    }

    public static void deleteAccessKey(IAM $this, AccessKey accessKey) {
        $this.deleteAccessKey(new DeleteAccessKeyRequest(accessKey.accessKeyId()));
    }

    public static Seq roles(IAM $this) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listRoles().getRoles()).asScala()).map((Function1)new Serializable($this){

            public final Role apply(com.amazonaws.services.identitymanagement.model.Role r) {
                return Role$.MODULE$.apply(r);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static Role createRole(IAM $this, String name, String path, Policy assumeRolePolicy) {
        return $this.createRole(name, path, assumeRolePolicy.toJSON());
    }

    public static Role createRole(IAM $this, String name, String path, String assumeRolePolicyDocument) {
        return Role$.MODULE$.apply($this.createRole(new CreateRoleRequest().withRoleName(name).withPath(path).withAssumeRolePolicyDocument(assumeRolePolicyDocument)).getRole());
    }

    public static void delete(IAM $this, Role role) {
        $this.deleteRole(role);
    }

    public static void deleteRole(IAM $this, Role role) {
        $this.deleteRole(new DeleteRoleRequest().withRoleName(role.name()));
    }

    public static Seq policyNames(IAM $this, Role role) {
        return $this.rolePolicyNames(role);
    }

    public static Seq rolePolicyNames(IAM $this, Role role) {
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listRolePolicies(new ListRolePoliciesRequest().withRoleName(role.name())).getPolicyNames()).asScala()).toSeq();
    }

    public static void put(IAM $this, RolePolicy policy) {
        $this.putRolePolicy(policy);
    }

    public static void putRolePolicy(IAM $this, RolePolicy policy) {
        $this.putRolePolicy(policy.role(), policy.name(), policy.document());
    }

    public static void putRolePolicy(IAM $this, Role role, String policyName, Policy policy) {
        $this.putRolePolicy(role, policyName, policy.toJSON());
    }

    public static void putRolePolicy(IAM $this, Role role, String policyName, String policyDocument) {
        $this.putRolePolicy(new PutRolePolicyRequest().withRoleName(role.name()).withPolicyName(policyName).withPolicyDocument(policyDocument));
    }

    public static RolePolicy rolePolicy(IAM $this, Role role, String policyName) {
        return RolePolicy$.MODULE$.apply(role, $this.getRolePolicy(new GetRolePolicyRequest().withRoleName(role.name()).withPolicyName(policyName)));
    }

    public static void delete(IAM $this, RolePolicy policy) {
        $this.deleteRolePolicy(policy);
    }

    public static void deleteRolePolicy(IAM $this, RolePolicy policy) {
        $this.deleteRolePolicy(new DeleteRolePolicyRequest().withRoleName(policy.role().name()).withPolicyName(policy.name()));
    }

    public static Seq instanceProfiles(IAM $this) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listInstanceProfiles().getInstanceProfiles()).asScala()).map((Function1)new Serializable($this){

            public final InstanceProfile apply(com.amazonaws.services.identitymanagement.model.InstanceProfile p) {
                return InstanceProfile$.MODULE$.apply(p);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static Seq instanceProfiles(IAM $this, Role role) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listInstanceProfilesForRole(new ListInstanceProfilesForRoleRequest().withRoleName(role.name())).getInstanceProfiles()).asScala()).map((Function1)new Serializable($this){

            public final InstanceProfile apply(com.amazonaws.services.identitymanagement.model.InstanceProfile p) {
                return InstanceProfile$.MODULE$.apply(p);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static InstanceProfile createInstanceProfile(IAM $this, String name, String path) {
        return InstanceProfile$.MODULE$.apply($this.createInstanceProfile(new CreateInstanceProfileRequest().withInstanceProfileName(name).withPath(path)).getInstanceProfile());
    }

    public static void addRoleToInstanceProfile(IAM $this, InstanceProfile profile, Role role) {
        $this.addRoleToInstanceProfile(new AddRoleToInstanceProfileRequest().withInstanceProfileName(profile.name()).withRoleName(role.name()));
    }

    public static void removeRoleFromInstanceProfile(IAM $this, InstanceProfile profile, Role role) {
        $this.removeRoleFromInstanceProfile(new RemoveRoleFromInstanceProfileRequest().withInstanceProfileName(profile.name()).withRoleName(role.name()));
    }

    public static void delete(IAM $this, InstanceProfile profile) {
        $this.deleteInstanceProfile(profile);
    }

    public static void deleteInstanceProfile(IAM $this, InstanceProfile profile) {
        $this.deleteInstanceProfile(new DeleteInstanceProfileRequest().withInstanceProfileName(profile.name()));
    }

    public static LoginProfile createLoginProfile(IAM $this, User user, String password) {
        return LoginProfile$.MODULE$.apply(user, $this.createLoginProfile(new CreateLoginProfileRequest().withUserName(user.name()).withPassword(password)).getLoginProfile());
    }

    public static Option loginProfile(IAM $this, User user) {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply((Object)LoginProfile$.MODULE$.apply(user, $this.getLoginProfile(new GetLoginProfileRequest().withUserName(user.name())).getLoginProfile()));
        }
        catch (NoSuchEntityException noSuchEntityException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static void changeUserPassword(IAM $this, LoginProfile profile, String newPassword) {
        $this.updateLoginProfile(new UpdateLoginProfileRequest().withUserName(profile.user().name()).withPassword(newPassword));
    }

    public static void delete(IAM $this, LoginProfile profile) {
        $this.deleteLoginProfile(profile);
    }

    public static void deleteLoginProfile(IAM $this, LoginProfile profile) {
        $this.deleteLoginProfile(new DeleteLoginProfileRequest().withUserName(profile.user().name()));
    }

    public static Seq virtualMFADevices(IAM $this) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listVirtualMFADevices().getVirtualMFADevices()).asScala()).map((Function1)new Serializable($this){

            public final VirtualMFADevice apply(com.amazonaws.services.identitymanagement.model.VirtualMFADevice d) {
                return VirtualMFADevice$.MODULE$.apply(d);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static Seq virtualMFADevices(IAM $this, User user) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listMFADevices(new ListMFADevicesRequest().withUserName(user.name())).getMFADevices()).asScala()).map((Function1)new Serializable($this, user){
            private final User user$1;

            public final VirtualMFADevice apply(MFADevice d) {
                return VirtualMFADevice$.MODULE$.apply(this.user$1, d);
            }
            {
                this.user$1 = user$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static VirtualMFADevice createVirtualMFADevice(IAM $this, String name, String path) {
        return VirtualMFADevice$.MODULE$.apply($this.createVirtualMFADevice(new CreateVirtualMFADeviceRequest().withVirtualMFADeviceName(name).withPath(path)).getVirtualMFADevice());
    }

    public static void enableVirtualMFADevice(IAM $this, VirtualMFADevice device, User user, String authCode1, String authCode2) {
        $this.enableMFADevice(new EnableMFADeviceRequest().withUserName(user.name()).withSerialNumber(device.serialNumber()).withAuthenticationCode1(authCode1).withAuthenticationCode2(authCode2));
    }

    public static void disableVirtualMFADevice(IAM $this, VirtualMFADevice device, User user) {
        $this.deactivateMFADevice(new DeactivateMFADeviceRequest().withSerialNumber(device.serialNumber()).withUserName(user.name()));
    }

    public static void delete(IAM $this, VirtualMFADevice device) {
        $this.deleteVirtualMFADevice(device);
    }

    public static void deleteVirtualMFADevice(IAM $this, VirtualMFADevice device) {
        $this.deleteVirtualMFADevice(new DeleteVirtualMFADeviceRequest().withSerialNumber(device.serialNumber()));
    }

    public static void $init$(IAM $this) {
    }
}

