/*
 * Decompiled with CFR 0.152.
 */
package awscala.sqs;

import awscala.sqs.DeleteMessageBatchEntry;
import awscala.sqs.Message;
import awscala.sqs.Message$;
import awscala.sqs.MessageBatchEntry;
import awscala.sqs.Queue;
import awscala.sqs.SQS;
import awscala.sqs.SQSClientWithQueue;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.QueueDoesNotExistException;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.util.List;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class SQS$class {
    public static SQS at(SQS $this, Region region) {
        $this.setRegion(region);
        return $this;
    }

    public static Queue createQueueAndReturnQueueName(SQS $this, String name) {
        CreateQueueResult result = $this.createQueue(new CreateQueueRequest(name));
        return new Queue(result.getQueueUrl());
    }

    public static void delete(SQS $this, Queue queue2) {
        $this.deleteQueue(queue2);
    }

    public static void deleteQueue(SQS $this, Queue queue2) {
        $this.deleteQueue(new DeleteQueueRequest(queue2.url()));
    }

    public static Seq queues(SQS $this) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listQueues().getQueueUrls()).asScala()).map((Function1)new Serializable($this){

            public final Queue apply(String url) {
                return new Queue(url);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static Option queue(SQS $this, String name) {
        return $this.queues().find((Function1)new Serializable($this, name){
            private final String name$1;

            public final boolean apply(Queue x$1) {
                Object object = Predef$.MODULE$.refArrayOps((Object[])x$1.url().split("/")).last();
                String string = this.name$1;
                return !(object != null ? !object.equals(string) : string != null);
            }
            {
                this.name$1 = name$1;
            }
        });
    }

    public static Option queueUrl(SQS $this, String name) {
        Some some;
        try {
            some = new Some((Object)$this.getQueueUrl(new GetQueueUrlRequest(name)).getQueueUrl());
        }
        catch (QueueDoesNotExistException queueDoesNotExistException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public static Object withQueue(SQS $this, Queue queue2, Function1 op) {
        return op.apply((Object)new SQSClientWithQueue($this, queue2));
    }

    public static Map queueAttributes(SQS $this, Queue queue2, String attributeName) {
        GetQueueAttributesResult result = $this.getQueueAttributes(new GetQueueAttributesRequest(queue2.url(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{attributeName}))).asJava()));
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(result.getAttributes()).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public static SendMessageResult send(SQS $this, Queue queue2, String messageBody) {
        return $this.sendMessage(queue2, messageBody);
    }

    public static SendMessageResult sendMessage(SQS $this, Queue queue2, String messageBody) {
        return $this.sendMessage(new SendMessageRequest(queue2.url(), messageBody));
    }

    public static SendMessageBatchResult sendMessages(SQS $this, Queue queue2, Seq messageBodies) {
        String batchId = new StringBuilder().append(Thread.currentThread().getId()).append((Object)"-").append((Object)BoxesRunTime.boxToLong((long)System.nanoTime())).toString();
        return $this.sendMessageBatch(queue2, (Seq<MessageBatchEntry>)((Seq)((TraversableLike)messageBodies.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this, batchId){
            private final String batchId$1;

            public final MessageBatchEntry apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String body = (String)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    MessageBatchEntry messageBatchEntry = new MessageBatchEntry(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.batchId$1, BoxesRunTime.boxToInteger((int)idx)})), body);
                    return messageBatchEntry;
                }
                throw new MatchError(tuple2);
            }
            {
                this.batchId$1 = batchId$1;
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public static SendMessageBatchResult sendMessageBatch(SQS $this, Queue queue2, Seq messages) {
        return $this.sendMessageBatch(new SendMessageBatchRequest(queue2.url(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)messages.map((Function1)new Serializable($this){

            public final SendMessageBatchRequestEntry apply(MessageBatchEntry x$2) {
                return x$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava()));
    }

    public static Seq receive(SQS $this, Queue queue2) {
        return $this.receiveMessage(queue2);
    }

    public static Seq receiveMessage(SQS $this, Queue queue2) {
        return $this.receiveMessage(queue2, 1, $this.receiveMessage$default$3());
    }

    public static Seq receiveMessage(SQS $this, Queue queue2, int count, Option requestCredentials) {
        ReceiveMessageRequest req = new ReceiveMessageRequest(queue2.url()).withMaxNumberOfMessages(Predef$.MODULE$.int2Integer(count));
        requestCredentials.foreach((Function1)new Serializable($this, req){
            private final ReceiveMessageRequest req$1;

            public final void apply(AWSSessionCredentials c) {
                this.req$1.setRequestCredentials((AWSCredentials)c);
            }
            {
                this.req$1 = req$1;
            }
        });
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.receiveMessage(req).getMessages()).asScala()).map((Function1)new Serializable($this, queue2){
            private final Queue queue$1;

            public final Message apply(com.amazonaws.services.sqs.model.Message msg) {
                return Message$.MODULE$.apply(this.queue$1, msg);
            }
            {
                this.queue$1 = queue$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static int receiveMessage$default$2(SQS $this) {
        return 10;
    }

    public static Option receiveMessage$default$3(SQS $this) {
        return None$.MODULE$;
    }

    public static void delete(SQS $this, Message message) {
        $this.deleteMessage(message, $this.deleteMessage$default$2());
    }

    public static void deleteMessage(SQS $this, Message message, Option requestCredentials) {
        DeleteMessageRequest request = new DeleteMessageRequest(message.queue().url(), message.receiptHandle());
        requestCredentials.foreach((Function1)new Serializable($this, request){
            private final DeleteMessageRequest request$1;

            public final void apply(AWSSessionCredentials c) {
                this.request$1.setRequestCredentials((AWSCredentials)c);
            }
            {
                this.request$1 = request$1;
            }
        });
        $this.deleteMessage(request);
    }

    public static Option deleteMessage$default$2(SQS $this) {
        return None$.MODULE$;
    }

    public static void deleteMessages(SQS $this, Seq messages, Option requestCredentials) {
        String batchId = new StringBuilder().append(Thread.currentThread().getId()).append((Object)"-").append((Object)BoxesRunTime.boxToLong((long)System.nanoTime())).toString();
        $this.deleteMessageBatch(((Message)((Object)messages.head())).queue(), (Seq<DeleteMessageBatchEntry>)((Seq)((TraversableLike)messages.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this, batchId){
            private final String batchId$2;

            public final DeleteMessageBatchEntry apply(Tuple2<Message, Object> x0$2) {
                Tuple2<Message, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Message msg = (Message)((Object)tuple2._1());
                    int idx = tuple2._2$mcI$sp();
                    DeleteMessageBatchEntry deleteMessageBatchEntry = new DeleteMessageBatchEntry(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.batchId$2, BoxesRunTime.boxToInteger((int)idx)})), msg.receiptHandle());
                    return deleteMessageBatchEntry;
                }
                throw new MatchError(tuple2);
            }
            {
                this.batchId$2 = batchId$2;
            }
        }, Seq$.MODULE$.canBuildFrom())), (Option<AWSSessionCredentials>)requestCredentials);
    }

    public static Option deleteMessages$default$2(SQS $this) {
        return None$.MODULE$;
    }

    public static void deleteMessageBatch(SQS $this, Queue queue2, Seq messages, Option requestCredentials) {
        DeleteMessageBatchRequest request = new DeleteMessageBatchRequest(queue2.url(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)messages.map((Function1)new Serializable($this){

            public final DeleteMessageBatchRequestEntry apply(DeleteMessageBatchEntry x$3) {
                return x$3;
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava());
        requestCredentials.foreach((Function1)new Serializable($this, request){
            private final DeleteMessageBatchRequest request$2;

            public final void apply(AWSSessionCredentials c) {
                this.request$2.setRequestCredentials((AWSCredentials)c);
            }
            {
                this.request$2 = request$2;
            }
        });
        $this.deleteMessageBatch(request);
    }

    public static Option deleteMessageBatch$default$3(SQS $this) {
        return None$.MODULE$;
    }

    public static void $init$(SQS $this) {
    }
}

