/*
 * Decompiled with CFR 0.152.
 */
package awscala.s3;

import awscala.Region$;
import awscala.s3.AccessControlList;
import awscala.s3.AccessControlList$;
import awscala.s3.Bucket;
import awscala.s3.Bucket$;
import awscala.s3.BucketCrossOriginConfiguration;
import awscala.s3.BucketCrossOriginConfiguration$;
import awscala.s3.BucketLifecycleConfiguration;
import awscala.s3.BucketLifecycleConfiguration$;
import awscala.s3.BucketLoggingConfiguration;
import awscala.s3.BucketLoggingConfiguration$;
import awscala.s3.BucketNotificationConfiguration;
import awscala.s3.BucketNotificationConfiguration$;
import awscala.s3.BucketPolicy;
import awscala.s3.BucketPolicy$;
import awscala.s3.BucketTaggingConfiguration;
import awscala.s3.BucketTaggingConfiguration$;
import awscala.s3.BucketVersioningConfiguration;
import awscala.s3.BucketVersioningConfiguration$;
import awscala.s3.BucketWebsiteConfiguration;
import awscala.s3.BucketWebsiteConfiguration$;
import awscala.s3.Owner;
import awscala.s3.Owner$;
import awscala.s3.PutObjectResult;
import awscala.s3.PutObjectResult$;
import awscala.s3.S3;
import awscala.s3.S3$;
import awscala.s3.S3$Placeholder$4$;
import awscala.s3.S3Object;
import awscala.s3.S3Object$;
import awscala.s3.S3ObjectSummary;
import awscala.s3.S3ObjectSummary$;
import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.DeleteVersionRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public abstract class S3$class {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static S3$Placeholder$4$ Placeholder$2$lzycompute(S3 x$1, VolatileObjectRef x$2) {
        S3 s3 = x$1;
        synchronized (s3) {
            if (x$2.elem != null) return (S3$Placeholder$4$)((Object)x$2.elem);
            x$2.elem = new S3$Placeholder$4$(x$1, x$2);
            return (S3$Placeholder$4$)((Object)x$2.elem);
        }
    }

    private static String s3RegionHack(S3 $this, String regionName) {
        String string = regionName;
        String string2 = "us-east-1".equals(string) ? "US" : regionName;
        return string2;
    }

    public static S3 at(S3 $this, Region region) {
        $this.setRegion(region);
        $this.awscala$s3$S3$$region_$eq(com.amazonaws.services.s3.model.Region.fromValue((String)S3$class.s3RegionHack($this, region.getName())));
        return $this;
    }

    public static Owner s3AccountOwner(S3 $this) {
        return Owner$.MODULE$.apply($this.getS3AccountOwner());
    }

    public static Seq buckets(S3 $this) {
        return (Seq)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.listBuckets()).asScala()).toSeq().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Bucket apply(com.amazonaws.services.s3.model.Bucket b) {
                return Bucket$.MODULE$.apply(b);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Option bucket(S3 $this, String name) {
        return $this.buckets().find((Function1)new Serializable($this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final boolean apply(Bucket x$1) {
                String string = x$1.name();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.name$1 = name$1;
            }
        });
    }

    public static AccessControlList acl(S3 $this, Bucket bucket2) {
        return $this.bucketAcl(bucket2.name());
    }

    public static AccessControlList bucketAcl(S3 $this, String name) {
        return AccessControlList$.MODULE$.apply($this.getBucketAcl(name));
    }

    public static void bucketAcl(S3 $this, Bucket bucket2, AccessControlList acl) {
        $this.setBucketAcl(bucket2.name(), acl);
    }

    public static String location(S3 $this, Bucket bucket2) {
        return $this.getBucketLocation(bucket2.name());
    }

    public static BucketCrossOriginConfiguration crossOriginConfig(S3 $this, Bucket bucket2) {
        return BucketCrossOriginConfiguration$.MODULE$.apply(bucket2, $this.getBucketCrossOriginConfiguration(bucket2.name()));
    }

    public static BucketLifecycleConfiguration lifecycleConfig(S3 $this, Bucket bucket2) {
        return BucketLifecycleConfiguration$.MODULE$.apply(bucket2, $this.getBucketLifecycleConfiguration(bucket2.name()));
    }

    public static BucketPolicy policy(S3 $this, Bucket bucket2) {
        return BucketPolicy$.MODULE$.apply(bucket2, $this.getBucketPolicy(bucket2.name()));
    }

    public static BucketLoggingConfiguration loggingConfig(S3 $this, Bucket bucket2) {
        return BucketLoggingConfiguration$.MODULE$.apply($this.getBucketLoggingConfiguration(bucket2.name()));
    }

    public static BucketNotificationConfiguration notificationConfig(S3 $this, Bucket bucket2) {
        return BucketNotificationConfiguration$.MODULE$.apply(bucket2, $this.getBucketNotificationConfiguration(bucket2.name()));
    }

    public static BucketTaggingConfiguration taggingConfig(S3 $this, Bucket bucket2) {
        return BucketTaggingConfiguration$.MODULE$.apply(bucket2, $this.getBucketTaggingConfiguration(bucket2.name()));
    }

    public static BucketVersioningConfiguration versioningConfig(S3 $this, Bucket bucket2) {
        return BucketVersioningConfiguration$.MODULE$.apply(bucket2, $this.getBucketVersioningConfiguration(bucket2.name()));
    }

    public static BucketWebsiteConfiguration websiteConfig(S3 $this, Bucket bucket2) {
        return BucketWebsiteConfiguration$.MODULE$.apply(bucket2, $this.getBucketWebsiteConfiguration(bucket2.name()));
    }

    public static Bucket createBucket(S3 $this, String name) {
        return Bucket$.MODULE$.apply($this.createBucket(new CreateBucketRequest(name, $this.awscala$s3$S3$$region())));
    }

    public static void delete(S3 $this, Bucket bucket2) {
        $this.deleteBucket(bucket2);
    }

    public static void deleteBucket(S3 $this, Bucket bucket2) {
        $this.deleteBucket(bucket2.name());
    }

    public static void deleteCrossOriginConfig(S3 $this, Bucket bucket2) {
        $this.deleteBucketCrossOriginConfiguration(bucket2.name());
    }

    public static void deleteLifecycleConfig(S3 $this, Bucket bucket2) {
        $this.deleteBucketLifecycleConfiguration(bucket2.name());
    }

    public static void deletePolicy(S3 $this, Bucket bucket2) {
        $this.deleteBucketPolicy(bucket2.name());
    }

    public static void deleteTaggingConfig(S3 $this, Bucket bucket2) {
        $this.deleteBucketTaggingConfiguration(bucket2.name());
    }

    public static void deleteWebsiteConfig(S3 $this, Bucket bucket2) {
        $this.deleteBucketWebsiteConfiguration(bucket2.name());
    }

    public static Option get(S3 $this, Bucket bucket2, String key) {
        return $this.getObject(bucket2, key);
    }

    public static Option get(S3 $this, Bucket bucket2, String key, String versionId) {
        return $this.getObject(bucket2, key, versionId);
    }

    public static Option getObject(S3 $this, Bucket bucket2, String key) {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply((Object)$this.getObject(new GetObjectRequest(bucket2.name(), key))).map((Function1)new Serializable($this, bucket2){
                public static final long serialVersionUID = 0L;
                private final Bucket bucket$1;

                public final S3Object apply(com.amazonaws.services.s3.model.S3Object obj) {
                    return S3Object$.MODULE$.apply(this.bucket$1, obj);
                }
                {
                    this.bucket$1 = bucket$1;
                }
            });
        }
        catch (AmazonS3Exception amazonS3Exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static Option getObject(S3 $this, Bucket bucket2, String key, String versionId) {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply((Object)$this.getObject(new GetObjectRequest(bucket2.name(), key, versionId))).map((Function1)new Serializable($this, bucket2){
                public static final long serialVersionUID = 0L;
                private final Bucket bucket$2;

                public final S3Object apply(com.amazonaws.services.s3.model.S3Object obj) {
                    return S3Object$.MODULE$.apply(this.bucket$2, obj);
                }
                {
                    this.bucket$2 = bucket$2;
                }
            });
        }
        catch (AmazonS3Exception amazonS3Exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static ObjectMetadata metadata(S3 $this, Bucket bucket2, String key) {
        return $this.getObjectMetadata(bucket2.name(), key);
    }

    public static Seq objectSummaries(S3 $this, Bucket bucket2) {
        return $this.objectSummaries(bucket2, "");
    }

    public static Stream objectSummaries(S3 $this, Bucket bucket2, String prefix) {
        VolatileObjectRef Placeholder$module = VolatileObjectRef.zero();
        String string = prefix;
        public class Awscala_s3_S3$Placeholder$3
        implements Product,
        Serializable {
            private final List<S3ObjectSummary> objectSummaries;
            private final List<String> prefixes;
            private final Option<ObjectListing> objectListing;
            public final /* synthetic */ S3 $outer;

            public List<S3ObjectSummary> objectSummaries() {
                return this.objectSummaries;
            }

            public List<String> prefixes() {
                return this.prefixes;
            }

            public Option<ObjectListing> objectListing() {
                return this.objectListing;
            }

            public Awscala_s3_S3$Placeholder$3 copy(List<S3ObjectSummary> objectSummaries, List<String> prefixes, Option<ObjectListing> objectListing) {
                return new Awscala_s3_S3$Placeholder$3(this.awscala$s3$S3$Placeholder$$$outer(), objectSummaries, prefixes, objectListing);
            }

            public List<S3ObjectSummary> copy$default$1() {
                return this.objectSummaries();
            }

            public List<String> copy$default$2() {
                return this.prefixes();
            }

            public Option<ObjectListing> copy$default$3() {
                return this.objectListing();
            }

            public String productPrefix() {
                return "Placeholder";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Option<ObjectListing> option;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 2: {
                        option = this.objectListing();
                        break;
                    }
                    case 1: {
                        option = this.prefixes();
                        break;
                    }
                    case 0: {
                        option = this.objectSummaries();
                    }
                }
                return option;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Awscala_s3_S3$Placeholder$3;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Awscala_s3_S3$Placeholder$3)) return false;
                boolean bl = true;
                if (!bl) return false;
                Awscala_s3_S3$Placeholder$3 var4_4 = (Awscala_s3_S3$Placeholder$3)x$1;
                List<S3ObjectSummary> list = this.objectSummaries();
                List<S3ObjectSummary> list2 = var4_4.objectSummaries();
                if (list == null) {
                    if (list2 != null) {
                        return false;
                    }
                } else if (!list.equals(list2)) return false;
                List<String> list3 = this.prefixes();
                List<String> list4 = var4_4.prefixes();
                if (list3 == null) {
                    if (list4 != null) {
                        return false;
                    }
                } else if (!list3.equals(list4)) return false;
                Option<ObjectListing> option = this.objectListing();
                Option<ObjectListing> option2 = var4_4.objectListing();
                if (option == null) {
                    if (option2 != null) {
                        return false;
                    }
                } else if (!option.equals(option2)) return false;
                if (!var4_4.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ S3 awscala$s3$S3$Placeholder$$$outer() {
                return this.$outer;
            }

            public Awscala_s3_S3$Placeholder$3(S3 $outer, List<S3ObjectSummary> objectSummaries, List<String> prefixes, Option<ObjectListing> objectListing) {
                this.objectSummaries = objectSummaries;
                this.prefixes = prefixes;
                this.objectListing = objectListing;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.class.$init$((Product)this);
            }
        }
        Awscala_s3_S3$Placeholder$3 var4_5 = S3$class.Placeholder$2($this, Placeholder$module).apply((List<S3ObjectSummary>)Nil$.MODULE$, (List<String>)Nil$.MODULE$.$colon$colon((Object)string), (Option<ObjectListing>)None$.MODULE$);
        return S3$class.stream$1($this, Nil$.MODULE$.$colon$colon((Object)var4_5), Placeholder$module, bucket2);
    }

    public static Seq keys(S3 $this, Bucket bucket2) {
        return (Seq)$this.objectSummaries(bucket2).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(S3ObjectSummary os) {
                return os.getKey();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq keys(S3 $this, Bucket bucket2, String prefix) {
        return (Seq)$this.objectSummaries(bucket2, prefix).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(S3ObjectSummary os) {
                return os.getKey();
            }
        }, Stream$.MODULE$.canBuildFrom());
    }

    public static Stream ls(S3 $this, Bucket bucket2, String prefix) {
        ListObjectsRequest request = new ListObjectsRequest().withBucketName(bucket2.getName()).withPrefix(prefix).withDelimiter("/");
        ObjectListing firstListing = $this.listObjects(request);
        return S3$class.completeStream$1($this, firstListing, bucket2);
    }

    public static AccessControlList acl(S3 $this, S3Object obj) {
        return $this.acl(obj.bucket(), obj.key());
    }

    public static AccessControlList acl(S3 $this, Bucket bucket2, String key) {
        return AccessControlList$.MODULE$.apply($this.getObjectAcl(bucket2.name(), key));
    }

    public static void acl(S3 $this, S3Object obj, AccessControlList acl) {
        $this.setObjectAcl(obj.bucket().name(), obj.key(), acl);
    }

    public static void acl(S3 $this, S3Object obj, CannedAccessControlList acl) {
        $this.setObjectAcl(obj.bucket().name(), obj.key(), acl);
    }

    public static void acl(S3 $this, Bucket bucket2, String key, AccessControlList acl) {
        $this.setObjectAcl(bucket2.name(), key, acl);
    }

    public static void acl(S3 $this, Bucket bucket2, String key, CannedAccessControlList acl) {
        $this.setObjectAcl(bucket2.name(), key, acl);
    }

    public static PutObjectResult put(S3 $this, Bucket bucket2, String key, File file) {
        return $this.putObject(bucket2, key, file);
    }

    public static PutObjectResult putAsPublicRead(S3 $this, Bucket bucket2, String key, File file) {
        return $this.putObjectAsPublicRead(bucket2, key, file);
    }

    public static PutObjectResult putAsPublicReadWrite(S3 $this, Bucket bucket2, String key, File file) {
        return $this.putObjectAsPublicReadWrite(bucket2, key, file);
    }

    public static PutObjectResult putObject(S3 $this, Bucket bucket2, String key, File file) {
        return PutObjectResult$.MODULE$.apply(bucket2, key, $this.putObject(bucket2.name(), key, file));
    }

    public static PutObjectResult putObjectAsPublicRead(S3 $this, Bucket bucket2, String key, File file) {
        return PutObjectResult$.MODULE$.apply(bucket2, key, $this.putObject(new PutObjectRequest(bucket2.name(), key, file).withCannedAcl(CannedAccessControlList.PublicRead)));
    }

    public static PutObjectResult putObjectAsPublicReadWrite(S3 $this, Bucket bucket2, String key, File file) {
        return PutObjectResult$.MODULE$.apply(bucket2, key, $this.putObject(new PutObjectRequest(bucket2.name(), key, file).withCannedAcl(CannedAccessControlList.PublicReadWrite)));
    }

    public static PutObjectResult put(S3 $this, Bucket bucket2, String key, byte[] bytes, ObjectMetadata metadata) {
        return $this.putObject(bucket2, key, bytes, metadata);
    }

    public static PutObjectResult putAsPublicRead(S3 $this, Bucket bucket2, String key, byte[] bytes, ObjectMetadata metadata) {
        return $this.putObjectAsPublicRead(bucket2, key, bytes, metadata);
    }

    public static PutObjectResult putObject(S3 $this, Bucket bucket2, String key, byte[] bytes, ObjectMetadata metadata) {
        return PutObjectResult$.MODULE$.apply(bucket2, key, $this.putObject(new PutObjectRequest(bucket2.name(), key, (InputStream)new ByteArrayInputStream(bytes), metadata)));
    }

    public static PutObjectResult putObjectAsPublicRead(S3 $this, Bucket bucket2, String key, byte[] bytes, ObjectMetadata metadata) {
        return PutObjectResult$.MODULE$.apply(bucket2, key, $this.putObject(new PutObjectRequest(bucket2.name(), key, (InputStream)new ByteArrayInputStream(bytes), metadata).withCannedAcl(CannedAccessControlList.PublicRead)));
    }

    public static PutObjectResult copy(S3 $this, S3Object from, S3Object to) {
        return $this.copyObject(from, to);
    }

    public static PutObjectResult copyObject(S3 $this, S3Object from, S3Object to) {
        CopyObjectResult result = $this.copyObject(from.bucket().name(), from.key(), to.bucket().name(), to.key());
        return PutObjectResult$.MODULE$.apply(to.bucket(), to.key(), result);
    }

    public static void delete(S3 $this, S3Object obj) {
        $this.deleteObject(obj);
    }

    public static void deleteObject(S3 $this, S3Object obj) {
        $this.deleteObject(obj.bucket().name(), obj.key());
    }

    public static void deleteVersion(S3 $this, S3Object obj, String versionId) {
        $this.deleteObjectVersion(obj, versionId);
    }

    public static void deleteObjectVersion(S3 $this, S3Object obj, String versionId) {
        $this.deleteVersion(new DeleteVersionRequest(obj.bucket().name(), obj.key(), versionId));
    }

    public static void deleteObjects(S3 $this, Seq objs) {
        objs.groupBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Bucket apply(S3Object x$10) {
                return x$10.bucket();
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3 $outer;

            public final Option<DeleteObjectsResult> apply(Tuple2<Bucket, Seq<S3Object>> x) {
                return ((TraversableLike)x._2()).headOption().map((Function1)new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ S3$.anonfun.deleteObjects.2 $outer;
                    private final Tuple2 x$11;

                    public final DeleteObjectsResult apply(S3Object obj) {
                        DeleteObjectsRequest req = new DeleteObjectsRequest(obj.bucket().name());
                        req.setKeys((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)this.x$11._2()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final DeleteObjectsRequest.KeyVersion apply(S3Object obj) {
                                return new DeleteObjectsRequest.KeyVersion(obj.key(), obj.versionId());
                            }
                        }, Seq$.MODULE$.canBuildFrom())).asJava());
                        return this.$outer.awscala$s3$S3$$anonfun$$$outer().deleteObjects(req);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x$11 = x$11;
                    }
                });
            }

            public /* synthetic */ S3 awscala$s3$S3$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public static URL generatePresignedUrl(S3 $this, S3Object obj, DateTime expiration) {
        return $this.generatePresignedUrl(obj.bucket().name(), obj.key(), expiration.toDate());
    }

    public static final S3$Placeholder$4$ Placeholder$2(S3 $this, VolatileObjectRef Placeholder$module$1) {
        return Placeholder$module$1.elem == null ? S3$class.Placeholder$2$lzycompute($this, Placeholder$module$1) : (S3$Placeholder$4$)((Object)Placeholder$module$1.elem);
    }

    private static final List getSummaries$1(S3 $this, ObjectListing listing, Bucket bucket$3) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(listing.getObjectSummaries()).asScala()).map((Function1)new Serializable($this, bucket$3){
            public static final long serialVersionUID = 0L;
            private final Bucket bucket$3;

            public final S3ObjectSummary apply(com.amazonaws.services.s3.model.S3ObjectSummary s) {
                return S3ObjectSummary$.MODULE$.apply(this.bucket$3, s);
            }
            {
                this.bucket$3 = bucket$3;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
    }

    private static final S3.Placeholder.3 getPlaceholder$1(S3 $this, ObjectListing listing, VolatileObjectRef Placeholder$module$1, Bucket bucket$3) {
        return S3$class.Placeholder$2($this, Placeholder$module$1).apply((List<S3ObjectSummary>)S3$class.getSummaries$1($this, listing, bucket$3), (List<String>)S3$class.getPrefixes$1($this, listing), (Option<ObjectListing>)new Some((Object)listing));
    }

    private static final List getPrefixes$1(S3 $this, ObjectListing listing) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(listing.getCommonPrefixes()).asScala()).toList();
    }

    private static final ObjectListing getListing$1(S3 $this, String prefix, Bucket bucket$3) {
        return $this.listObjects(bucket$3.name(), prefix);
    }

    public static final Stream stream$1(S3 $this, List work, VolatileObjectRef Placeholder$module$1, Bucket bucket$3) {
        Tuple2 tuple2;
        block4: {
            Stream stream2;
            block3: {
                Option option;
                block2: {
                    tuple2 = S3$class.next$1($this, work, Placeholder$module$1, bucket$3);
                    if (tuple2 == null) break block2;
                    Option option2 = (Option)tuple2._1();
                    List more = (List)tuple2._2();
                    if (!(option2 instanceof Some)) break block2;
                    Some some = (Some)option2;
                    S3ObjectSummary e = (S3ObjectSummary)((Object)some.x());
                    stream2 = Stream.cons$.MODULE$.apply((Object)e, (Function0)new Serializable($this, more, Placeholder$module$1, bucket$3){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ S3 $outer;
                        private final List more$1;
                        private final VolatileObjectRef Placeholder$module$1;
                        private final Bucket bucket$3;

                        public final Stream<S3ObjectSummary> apply() {
                            return S3$class.stream$1(this.$outer, this.more$1, this.Placeholder$module$1, this.bucket$3);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.more$1 = more$1;
                            this.Placeholder$module$1 = Placeholder$module$1;
                            this.bucket$3 = bucket$3;
                        }
                    });
                    break block3;
                }
                if (tuple2 == null || !None$.MODULE$.equals(option = (Option)tuple2._1())) break block4;
                stream2 = package$.MODULE$.Stream().empty();
            }
            return stream2;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Tuple2 next$1(S3 $this, List work, VolatileObjectRef Placeholder$module$1, Bucket bucket$3) {
        List list;
        block8: {
            Awscala_s3_S3$Placeholder$3 var10_8;
            while (true) {
                Option<Tuple3<List<S3ObjectSummary>, List<String>, Option<ObjectListing>>> option;
                Option<Tuple3<List<S3ObjectSummary>, List<String>, Option<ObjectListing>>> option2;
                Option<Tuple3<List<S3ObjectSummary>, List<String>, Option<ObjectListing>>> option3;
                List tail;
                block11: {
                    Tuple2 tuple2;
                    block10: {
                        Tuple2 tuple22;
                        block9: {
                            if (!Nil$.MODULE$.equals(list = work)) break block9;
                            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)Nil$.MODULE$);
                            break block10;
                        }
                        if (!(list instanceof .colon.colon)) break block8;
                        .colon.colon colon2 = (.colon.colon)list;
                        Awscala_s3_S3$Placeholder$3 head = (Awscala_s3_S3$Placeholder$3)colon2.head();
                        tail = colon2.tl$1();
                        var10_8 = head;
                        Option<Tuple3<List<S3ObjectSummary>, List<String>, Option<ObjectListing>>> option4 = S3$class.Placeholder$2($this, Placeholder$module$1).unapply(var10_8);
                        if (option4.isEmpty()) break block11;
                        List list2 = (List)((Tuple3)option4.get())._1();
                        List prefixes = (List)((Tuple3)option4.get())._2();
                        Option listing = (Option)((Tuple3)option4.get())._3();
                        if (!(list2 instanceof .colon.colon)) break block11;
                        .colon.colon colon3 = (.colon.colon)list2;
                        S3ObjectSummary shead = (S3ObjectSummary)((Object)colon3.head());
                        List stail = colon3.tl$1();
                        Awscala_s3_S3$Placeholder$3 var19_36 = S3$class.Placeholder$2($this, Placeholder$module$1).apply((List<S3ObjectSummary>)stail, (List<String>)prefixes, (Option<ObjectListing>)listing);
                        tuple2 = tuple22 = new Tuple2((Object)new Some((Object)shead), (Object)tail.$colon$colon((Object)var19_36));
                    }
                    return tuple2;
                }
                if (!(option3 = S3$class.Placeholder$2($this, Placeholder$module$1).unapply(var10_8)).isEmpty()) {
                    List list3 = (List)((Tuple3)option3.get())._1();
                    List list4 = (List)((Tuple3)option3.get())._2();
                    Option listing = (Option)((Tuple3)option3.get())._3();
                    if (Nil$.MODULE$.equals(list3) && list4 instanceof .colon.colon) {
                        .colon.colon colon4 = (.colon.colon)list4;
                        String phead = (String)colon4.head();
                        List ptail = colon4.tl$1();
                        Awscala_s3_S3$Placeholder$3 var27_20 = S3$class.getPlaceholder$1($this, S3$class.getListing$1($this, phead, bucket$3), Placeholder$module$1, bucket$3);
                        Awscala_s3_S3$Placeholder$3 var28_21 = S3$class.Placeholder$2($this, Placeholder$module$1).apply((List<S3ObjectSummary>)Nil$.MODULE$, (List<String>)ptail, (Option<ObjectListing>)listing);
                        work = tail.$colon$colon((Object)var28_21).$colon$colon((Object)var27_20);
                        continue;
                    }
                }
                if (!(option2 = S3$class.Placeholder$2($this, Placeholder$module$1).unapply(var10_8)).isEmpty()) {
                    Some some;
                    ObjectListing listing;
                    List list5 = (List)((Tuple3)option2.get())._1();
                    List list6 = (List)((Tuple3)option2.get())._2();
                    Option option5 = (Option)((Tuple3)option2.get())._3();
                    if (Nil$.MODULE$.equals(list5) && Nil$.MODULE$.equals(list6) && option5 instanceof Some && (listing = (ObjectListing)(some = (Some)option5).x()).isTruncated()) {
                        Awscala_s3_S3$Placeholder$3 var35_28 = S3$class.getPlaceholder$1($this, $this.listNextBatchOfObjects(listing), Placeholder$module$1, bucket$3);
                        work = tail.$colon$colon((Object)var35_28);
                        continue;
                    }
                }
                if ((option = S3$class.Placeholder$2($this, Placeholder$module$1).unapply(var10_8)).isEmpty()) break;
                List list7 = (List)((Tuple3)option.get())._1();
                List list8 = (List)((Tuple3)option.get())._2();
                if (!Nil$.MODULE$.equals(list7) || !Nil$.MODULE$.equals(list8)) break;
                work = tail;
            }
            throw new MatchError((Object)var10_8);
        }
        throw new MatchError((Object)list);
    }

    public static final Stream completeStream$1(S3 $this, ObjectListing listing, Bucket bucket$4) {
        Stream prefixes = ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(listing.getCommonPrefixes()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Left<String, Nothing$> apply(String pre) {
                return package$.MODULE$.Left().apply((Object)pre);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toStream();
        Stream objects = ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(listing.getObjectSummaries()).asScala()).map((Function1)new Serializable($this, bucket$4){
            public static final long serialVersionUID = 0L;
            private final Bucket bucket$4;

            public final Right<Nothing$, S3ObjectSummary> apply(com.amazonaws.services.s3.model.S3ObjectSummary s) {
                return package$.MODULE$.Right().apply((Object)((Object)S3ObjectSummary$.MODULE$.apply(this.bucket$4, s)));
            }
            {
                this.bucket$4 = bucket$4;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toStream();
        Stream stream2 = prefixes;
        return Stream$.MODULE$.consWrapper((Function0)new Serializable($this, listing, objects, bucket$4){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3 $outer;
            public final ObjectListing listing$1;
            private final Stream objects$1;
            public final Bucket bucket$4;

            public final Stream<Either<String, S3ObjectSummary>> apply() {
                Stream stream2 = this.objects$1;
                return Stream$.MODULE$.consWrapper((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ S3$.anonfun.completeStream.1.1 $outer;

                    public final Stream<Either<String, S3ObjectSummary>> apply() {
                        return this.$outer.listing$1.isTruncated() ? S3$class.completeStream$1(this.$outer.awscala$s3$S3$$anonfun$$$outer(), this.$outer.awscala$s3$S3$$anonfun$$$outer().listNextBatchOfObjects(this.$outer.listing$1), this.$outer.bucket$4) : package$.MODULE$.Stream().empty();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).$hash$colon$colon$colon(stream2);
            }

            public /* synthetic */ S3 awscala$s3$S3$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.listing$1 = listing$1;
                this.objects$1 = objects$1;
                this.bucket$4 = bucket$4;
            }
        }).$hash$colon$colon$colon(stream2);
    }

    public static void $init$(S3 $this) {
        $this.awscala$s3$S3$$region_$eq(com.amazonaws.services.s3.model.Region.fromValue((String)S3$class.s3RegionHack($this, Region$.MODULE$.default().getName())));
    }
}

