/*
 * Decompiled with CFR 0.152.
 */
package awscala.sts;

import awscala.Policy;
import awscala.sts.FederatedUser$;
import awscala.sts.FederationToken;
import awscala.sts.STS;
import awscala.sts.SessionToken;
import awscala.sts.TemporaryCredentials;
import awscala.sts.TemporaryCredentials$;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest;
import com.amazonaws.services.securitytoken.model.GetFederationTokenRequest;
import com.amazonaws.services.securitytoken.model.GetFederationTokenResult;
import com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import com.amazonaws.util.json.JSONObject;
import java.net.URL;
import java.net.URLEncoder;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;

public abstract class STS$class {
    public static SessionToken sessionToken(STS $this) {
        return new SessionToken(TemporaryCredentials$.MODULE$.apply($this.getSessionToken().getCredentials()));
    }

    public static SessionToken sessionToken(STS $this, String serialNumber, String tokenCode, int durationSeconds) {
        return new SessionToken(TemporaryCredentials$.MODULE$.apply($this.getSessionToken(new GetSessionTokenRequest().withSerialNumber(serialNumber).withTokenCode(tokenCode).withDurationSeconds(Predef$.MODULE$.int2Integer(durationSeconds))).getCredentials()));
    }

    public static FederationToken federationToken(STS $this, String name, Policy policy, int durationSeconds) {
        GetFederationTokenResult result = $this.getFederationToken(new GetFederationTokenRequest().withName(name).withPolicy(policy.toJSON()).withDurationSeconds(Predef$.MODULE$.int2Integer(durationSeconds)));
        return new FederationToken(FederatedUser$.MODULE$.apply(result.getFederatedUser()), TemporaryCredentials$.MODULE$.apply(result.getCredentials()));
    }

    public static String decodeAuthorizationMessage(STS $this, String message) {
        return $this.decodeAuthorizationMessage(new DecodeAuthorizationMessageRequest().withEncodedMessage(message)).getDecodedMessage();
    }

    public static String signinToken(STS $this, TemporaryCredentials credentials) {
        String sessionJsonValue = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"sessionId\":\"", "\",\"sessionKey\":\"", "\",\"sessionToken\":\"", "\"}\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{credentials.accessKeyId(), credentials.secretAccessKey(), credentials.sessionToken()}));
        String url = new StringBuilder().append((Object)$this.awscala$sts$STS$$SIGNIN_URL()).append((Object)"?Action=getSigninToken&SessionType=json&Session=").append((Object)URLEncoder.encode(sessionJsonValue, "UTF-8")).toString();
        String response = Source$.MODULE$.fromURL(new URL(url), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n");
        return new JSONObject(response).getString("SigninToken");
    }

    public static String loginUrl(STS $this, TemporaryCredentials credentials, String consoleUrl, String issuerUrl) {
        String token = URLEncoder.encode($this.signinToken(credentials), "UTF-8");
        String issuer = URLEncoder.encode(issuerUrl, "UTF-8");
        String destination = URLEncoder.encode(consoleUrl, "UTF-8");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "?Action=login&SigninToken=", "&Issuer=", "&Destination=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.awscala$sts$STS$$SIGNIN_URL(), token, issuer, destination}));
    }

    public static String loginUrl$default$2(STS $this) {
        return "https://console.aws.amazon.com/iam";
    }

    public static String loginUrl$default$3(STS $this) {
        return "";
    }

    public static TemporaryCredentials assumeRole(STS $this, String id, String arn, String sessionKey) {
        AssumeRoleRequest assumeRoleReq = new AssumeRoleRequest();
        assumeRoleReq.setExternalId(id);
        assumeRoleReq.setRoleArn(arn);
        assumeRoleReq.setRoleSessionName(sessionKey);
        AssumeRoleResult response = $this.assumeRole(assumeRoleReq);
        return TemporaryCredentials$.MODULE$.apply(response.getCredentials());
    }

    public static void $init$(STS $this) {
        $this.awscala$sts$STS$_setter_$awscala$sts$STS$$SIGNIN_URL_$eq("https://signin.aws.amazon.com/federation");
    }
}

