/*
 * Decompiled with CFR 0.152.
 */
package awscala.redshift;

import awscala.AvailabilityZone;
import awscala.redshift.Cluster;
import awscala.redshift.Cluster$;
import awscala.redshift.ClusterParameterGroup;
import awscala.redshift.ClusterParameterGroup$;
import awscala.redshift.ClusterSecurityGroup;
import awscala.redshift.ClusterSecurityGroup$;
import awscala.redshift.ClusterSubnetGroup;
import awscala.redshift.ClusterSubnetGroup$;
import awscala.redshift.ClusterType;
import awscala.redshift.ClusterType$;
import awscala.redshift.ClusterVersion;
import awscala.redshift.ClusterVersion$;
import awscala.redshift.EC2SecurityGroup;
import awscala.redshift.Event;
import awscala.redshift.Event$;
import awscala.redshift.NewCluster;
import awscala.redshift.Redshift;
import awscala.redshift.ReservedNode;
import awscala.redshift.ReservedNode$;
import awscala.redshift.Snapshot;
import awscala.redshift.Snapshot$;
import awscala.redshift.SnapshotType;
import com.amazonaws.regions.Region;
import com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;
import com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest;
import com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.CreateClusterRequest;
import com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest;
import com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest;
import com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.DeleteClusterRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest;
import com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest;
import com.amazonaws.services.redshift.model.DescribeClustersRequest;
import com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest;
import java.util.Collection;
import org.joda.time.DateTime;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;

public abstract class Redshift$class {
    public static Redshift at(Redshift $this, Region region) {
        $this.setRegion(region);
        return $this;
    }

    public static Seq clusters(Redshift $this) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.describeClusters().getClusters()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Cluster apply(com.amazonaws.services.redshift.model.Cluster c) {
                return Cluster$.MODULE$.apply(c);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public static Option cluster(Redshift $this, String identifier, Option marker, Option maxRecords) {
        DescribeClustersRequest req = new DescribeClustersRequest().withClusterIdentifier(identifier);
        marker.foreach((Function1)new Serializable($this, req){
            public static final long serialVersionUID = 0L;
            private final DescribeClustersRequest req$1;

            public final void apply(String m) {
                this.req$1.setMarker(m);
            }
            {
                this.req$1 = req$1;
            }
        });
        maxRecords.foreach((Function1)new Serializable($this, req){
            public static final long serialVersionUID = 0L;
            private final DescribeClustersRequest req$1;

            public final void apply(int mr) {
                this.apply$mcVI$sp(mr);
            }

            public void apply$mcVI$sp(int mr) {
                this.req$1.setMaxRecords(Predef$.MODULE$.int2Integer(mr));
            }
            {
                this.req$1 = req$1;
            }
        });
        return ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.describeClusters(req).getClusters()).asScala()).headOption().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Cluster apply(com.amazonaws.services.redshift.model.Cluster c) {
                return Cluster$.MODULE$.apply(c);
            }
        });
    }

    public static Option cluster$default$2(Redshift $this) {
        return None$.MODULE$;
    }

    public static Option cluster$default$3(Redshift $this) {
        return None$.MODULE$;
    }

    public static Cluster createCluster(Redshift $this, NewCluster newCluster) {
        CreateClusterRequest req = new CreateClusterRequest().withAllowVersionUpgrade(Predef$.MODULE$.boolean2Boolean(newCluster.allowVersionUpgrade())).withAutomatedSnapshotRetentionPeriod(Predef$.MODULE$.int2Integer(newCluster.automatedSnapshotRetentionPeriod())).withAvailabilityZone((String)newCluster.availabilityZone().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(AvailabilityZone x$1) {
                return x$1.name();
            }
        }).orNull(Predef$.MODULE$.$conforms())).withClusterIdentifier(newCluster.identifier()).withClusterParameterGroupName((String)newCluster.parameterGroupName().orNull(Predef$.MODULE$.$conforms())).withClusterSecurityGroups((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newCluster.securityGroupNames()).asJava()).withClusterSubnetGroupName((String)newCluster.subnetGroupName().orNull(Predef$.MODULE$.$conforms())).withClusterType(newCluster.clusterType().name()).withClusterVersion(newCluster.clusterVersion().version()).withDBName(newCluster.dbName()).withEncrypted(Predef$.MODULE$.boolean2Boolean(newCluster.encrypted())).withMasterUsername(newCluster.masterUsername()).withMasterUserPassword(newCluster.masterUserPassword()).withNodeType(newCluster.nodeType().value()).withPort(Predef$.MODULE$.int2Integer(newCluster.port())).withPreferredMaintenanceWindow((String)newCluster.preferredMaintenanceWindow().orNull(Predef$.MODULE$.$conforms())).withPubliclyAccessible(Predef$.MODULE$.boolean2Boolean(newCluster.publiclyAccessible())).withVpcSecurityGroupIds((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newCluster.vpcSecurityGroupIds()).asJava());
        ClusterType clusterType = newCluster.clusterType();
        ClusterType clusterType2 = ClusterType$.MODULE$.MultiNode();
        if (!(clusterType != null ? !((Object)clusterType).equals(clusterType2) : clusterType2 != null)) {
            req.setNumberOfNodes(Predef$.MODULE$.int2Integer(newCluster.numOfNodes()));
        }
        return Cluster$.MODULE$.apply($this.createCluster(req));
    }

    public static void delete(Redshift $this, Cluster cluster2, String finalSnapshotIdentifier) {
        $this.deleteCluster(cluster2, finalSnapshotIdentifier);
    }

    public static void deleteCluster(Redshift $this, Cluster cluster2, String finalSnapshotIdentifier) {
        $this.deleteCluster(new DeleteClusterRequest().withClusterIdentifier(cluster2.identifier()).withFinalClusterSnapshotIdentifier(finalSnapshotIdentifier).withSkipFinalClusterSnapshot(Predef$.MODULE$.boolean2Boolean(false)));
    }

    public static void deleteWithoutFinalSnapshot(Redshift $this, Cluster cluster2) {
        $this.deleteClusterWithoutFinalSnapshot(cluster2);
    }

    public static void deleteClusterWithoutFinalSnapshot(Redshift $this, Cluster cluster2) {
        $this.deleteCluster(new DeleteClusterRequest().withClusterIdentifier(cluster2.identifier()).withSkipFinalClusterSnapshot(Predef$.MODULE$.boolean2Boolean(true)));
    }

    public static Seq clusterVersions(Redshift $this) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.describeClusterVersions().getClusterVersions()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ClusterVersion apply(com.amazonaws.services.redshift.model.ClusterVersion v) {
                return ClusterVersion$.MODULE$.apply(v);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public static Option clusterVersion(Redshift $this, String version, String paramtereGroupFamily, String marker, int maxRecords) {
        DescribeClusterVersionsRequest req = new DescribeClusterVersionsRequest().withClusterVersion(version);
        if (marker != null) {
            req.setMarker(marker);
        }
        if (maxRecords != -1) {
            req.setMaxRecords(Predef$.MODULE$.int2Integer(maxRecords));
        }
        if (paramtereGroupFamily != null) {
            req.setClusterParameterGroupFamily(paramtereGroupFamily);
        }
        return ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.describeClusterVersions(req).getClusterVersions()).asScala()).headOption().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ClusterVersion apply(com.amazonaws.services.redshift.model.ClusterVersion v) {
                return ClusterVersion$.MODULE$.apply(v);
            }
        });
    }

    public static String clusterVersion$default$2(Redshift $this) {
        return null;
    }

    public static String clusterVersion$default$3(Redshift $this) {
        return null;
    }

    public static int clusterVersion$default$4(Redshift $this) {
        return -1;
    }

    public static Seq reservedNodes(Redshift $this) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.describeReservedNodes().getReservedNodes()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ReservedNode apply(com.amazonaws.services.redshift.model.ReservedNode n) {
                return ReservedNode$.MODULE$.apply(n);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static Seq snapshots(Redshift $this) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.describeClusterSnapshots(new DescribeClusterSnapshotsRequest()).getSnapshots()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Snapshot apply(com.amazonaws.services.redshift.model.Snapshot s) {
                return Snapshot$.MODULE$.apply(s);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public static Option snapshot(Redshift $this, String snapshotIdentifier, String clusterIdentifier, DateTime from, DateTime to, String marker, int maxRecords, String ownerAccount, SnapshotType snapshotType) {
        DescribeClusterSnapshotsRequest req = new DescribeClusterSnapshotsRequest().withSnapshotIdentifier(snapshotIdentifier).withStartTime(from.toDate()).withMarker(marker).withMaxRecords(Predef$.MODULE$.int2Integer(maxRecords)).withOwnerAccount(ownerAccount).withSnapshotType(snapshotType.value());
        if (clusterIdentifier != null) {
            req.setClusterIdentifier(clusterIdentifier);
        }
        if (from != null) {
            req.setStartTime(from.toDate());
        }
        if (to != null) {
            req.setEndTime(to.toDate());
        }
        if (marker != null) {
            req.setMarker(marker);
        }
        if (maxRecords != -1) {
            req.setMaxRecords(Predef$.MODULE$.int2Integer(maxRecords));
        }
        if (ownerAccount != null) {
            req.setOwnerAccount(ownerAccount);
        }
        if (snapshotType != null) {
            req.setSnapshotType(snapshotType.value());
        }
        return ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.describeClusterSnapshots(req).getSnapshots()).asScala()).headOption().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Snapshot apply(com.amazonaws.services.redshift.model.Snapshot s) {
                return Snapshot$.MODULE$.apply(s);
            }
        });
    }

    public static String snapshot$default$2(Redshift $this) {
        return null;
    }

    public static DateTime snapshot$default$3(Redshift $this) {
        return null;
    }

    public static DateTime snapshot$default$4(Redshift $this) {
        return null;
    }

    public static String snapshot$default$5(Redshift $this) {
        return null;
    }

    public static int snapshot$default$6(Redshift $this) {
        return -1;
    }

    public static String snapshot$default$7(Redshift $this) {
        return null;
    }

    public static SnapshotType snapshot$default$8(Redshift $this) {
        return null;
    }

    public static Snapshot createSnapshot(Redshift $this, Cluster cluster2, String snapshotIdentifier) {
        return Snapshot$.MODULE$.apply($this.createClusterSnapshot(new CreateClusterSnapshotRequest().withClusterIdentifier(cluster2.identifier()).withSnapshotIdentifier(snapshotIdentifier)));
    }

    public static void authorizeAccess(Redshift $this, Snapshot snapshot2, String accountId) {
        $this.authorizeSnapshotAccess(snapshot2, accountId);
    }

    public static void authorizeSnapshotAccess(Redshift $this, Snapshot snapshot2, String accountId) {
        $this.authorizeSnapshotAccess(new AuthorizeSnapshotAccessRequest().withAccountWithRestoreAccess(accountId).withSnapshotClusterIdentifier(snapshot2.clusterIdentifier()).withSnapshotIdentifier(snapshot2.snapshotIdentifier()));
    }

    public static void revokeAccess(Redshift $this, Snapshot snapshot2, String accountId) {
        $this.revokeSnapshotAccess(snapshot2, accountId);
    }

    public static void revokeSnapshotAccess(Redshift $this, Snapshot snapshot2, String accountId) {
        $this.revokeSnapshotAccess(new RevokeSnapshotAccessRequest().withAccountWithRestoreAccess(accountId).withSnapshotClusterIdentifier(snapshot2.clusterIdentifier()).withSnapshotIdentifier(snapshot2.snapshotIdentifier()));
    }

    public static Snapshot copy(Redshift $this, Snapshot source, String targetIdentifier) {
        return $this.copySnapshot(source, targetIdentifier);
    }

    public static Snapshot copySnapshot(Redshift $this, Snapshot source, String targetIdentifier) {
        return Snapshot$.MODULE$.apply($this.copyClusterSnapshot(new CopyClusterSnapshotRequest().withTargetSnapshotIdentifier(targetIdentifier).withSourceSnapshotClusterIdentifier(source.clusterIdentifier()).withSourceSnapshotIdentifier(source.snapshotIdentifier())));
    }

    public static void delete(Redshift $this, Snapshot snapshot2) {
        $this.deleteSnapshot(snapshot2);
    }

    public static void deleteSnapshot(Redshift $this, Snapshot snapshot2) {
        $this.deleteClusterSnapshot(new DeleteClusterSnapshotRequest().withSnapshotClusterIdentifier(snapshot2.clusterIdentifier()).withSnapshotIdentifier(snapshot2.snapshotIdentifier()));
    }

    public static Seq events(Redshift $this) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.describeEvents().getEvents()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Event apply(com.amazonaws.services.redshift.model.Event e) {
                return Event$.MODULE$.apply(e);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public static Seq clusterParameterGroups(Redshift $this) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.describeClusterParameterGroups(new DescribeClusterParameterGroupsRequest()).getParameterGroups()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ClusterParameterGroup apply(com.amazonaws.services.redshift.model.ClusterParameterGroup g) {
                return ClusterParameterGroup$.MODULE$.apply(g);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public static Option clusterParameterGroup(Redshift $this, String name, String marker, int maxRecords) {
        DescribeClusterParameterGroupsRequest req = new DescribeClusterParameterGroupsRequest().withParameterGroupName(name);
        if (marker != null) {
            req.setMarker(marker);
        }
        if (maxRecords != -1) {
            req.setMaxRecords(Predef$.MODULE$.int2Integer(maxRecords));
        }
        return ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.describeClusterParameterGroups(req).getParameterGroups()).asScala()).headOption().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ClusterParameterGroup apply(com.amazonaws.services.redshift.model.ClusterParameterGroup g) {
                return ClusterParameterGroup$.MODULE$.apply(g);
            }
        });
    }

    public static String clusterParameterGroup$default$2(Redshift $this) {
        return null;
    }

    public static int clusterParameterGroup$default$3(Redshift $this) {
        return -1;
    }

    public static ClusterParameterGroup createClusterParameterGroup(Redshift $this, String name, String family, String description) {
        return ClusterParameterGroup$.MODULE$.apply($this.createClusterParameterGroup(new CreateClusterParameterGroupRequest().withParameterGroupName(name).withParameterGroupFamily(family).withDescription(description)));
    }

    public static void delete(Redshift $this, ClusterParameterGroup group) {
        $this.deleteClusterParameterGroup(group);
    }

    public static void deleteClusterParameterGroup(Redshift $this, ClusterParameterGroup group) {
        $this.deleteClusterParameterGroup(new DeleteClusterParameterGroupRequest().withParameterGroupName(group.name()));
    }

    public static void authorizeSecurityGroupIngress(Redshift $this, ClusterSecurityGroup securityGroup2, EC2SecurityGroup ec2SecurityGroup, String cidrip) {
        $this.authorizeClusterSecurityGroupIngress(new AuthorizeClusterSecurityGroupIngressRequest().withCIDRIP(cidrip).withClusterSecurityGroupName(securityGroup2.name()).withEC2SecurityGroupName(ec2SecurityGroup.name()).withEC2SecurityGroupOwnerId(ec2SecurityGroup.ownerId()));
    }

    public static Seq clusterSecurityGroups(Redshift $this) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.describeClusterSecurityGroups(new DescribeClusterSecurityGroupsRequest()).getClusterSecurityGroups()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ClusterSecurityGroup apply(com.amazonaws.services.redshift.model.ClusterSecurityGroup g) {
                return ClusterSecurityGroup$.MODULE$.apply(g);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public static Option clusterSecurityGroup(Redshift $this, String name, String marker, int maxRecords) {
        DescribeClusterSecurityGroupsRequest req = new DescribeClusterSecurityGroupsRequest().withClusterSecurityGroupName(name);
        if (marker != null) {
            req.setMarker(marker);
        }
        if (maxRecords != -1) {
            req.setMaxRecords(Predef$.MODULE$.int2Integer(maxRecords));
        }
        return ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.describeClusterSecurityGroups(req).getClusterSecurityGroups()).asScala()).headOption().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ClusterSecurityGroup apply(com.amazonaws.services.redshift.model.ClusterSecurityGroup g) {
                return ClusterSecurityGroup$.MODULE$.apply(g);
            }
        });
    }

    public static String clusterSecurityGroup$default$2(Redshift $this) {
        return null;
    }

    public static int clusterSecurityGroup$default$3(Redshift $this) {
        return -1;
    }

    public static ClusterSecurityGroup createClusterSecurityGroup(Redshift $this, String name, String description) {
        return ClusterSecurityGroup$.MODULE$.apply($this.createClusterSecurityGroup(new CreateClusterSecurityGroupRequest().withClusterSecurityGroupName(name).withDescription(description)));
    }

    public static void delete(Redshift $this, ClusterSecurityGroup group) {
        $this.deleteClusterSecurityGroup(group);
    }

    public static void deleteClusterSecurityGroup(Redshift $this, ClusterSecurityGroup group) {
        $this.deleteClusterSecurityGroup(new DeleteClusterSecurityGroupRequest().withClusterSecurityGroupName(group.name()));
    }

    public static Seq clusterSubnetGroups(Redshift $this) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.describeClusterSubnetGroups(new DescribeClusterSubnetGroupsRequest()).getClusterSubnetGroups()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ClusterSubnetGroup apply(com.amazonaws.services.redshift.model.ClusterSubnetGroup g) {
                return ClusterSubnetGroup$.MODULE$.apply(g);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public static Option clusterSubnetGroup(Redshift $this, String name, String marker, int maxRecords) {
        DescribeClusterSubnetGroupsRequest req = new DescribeClusterSubnetGroupsRequest().withClusterSubnetGroupName(name);
        if (marker != null) {
            req.setMarker(marker);
        }
        if (maxRecords != -1) {
            req.setMaxRecords(Predef$.MODULE$.int2Integer(maxRecords));
        }
        return ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.describeClusterSubnetGroups(req).getClusterSubnetGroups()).asScala()).headOption().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ClusterSubnetGroup apply(com.amazonaws.services.redshift.model.ClusterSubnetGroup g) {
                return ClusterSubnetGroup$.MODULE$.apply(g);
            }
        });
    }

    public static String clusterSubnetGroup$default$2(Redshift $this) {
        return null;
    }

    public static int clusterSubnetGroup$default$3(Redshift $this) {
        return -1;
    }

    public static ClusterSubnetGroup createSubnetGroup(Redshift $this, String name, String description, Seq subnetIds) {
        return ClusterSubnetGroup$.MODULE$.apply($this.createClusterSubnetGroup(new CreateClusterSubnetGroupRequest().withClusterSubnetGroupName(name).withDescription(description).withSubnetIds((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(subnetIds).asJava())));
    }

    public static void delete(Redshift $this, ClusterSubnetGroup group) {
        $this.deleteSubnetGroup(group);
    }

    public static void deleteSubnetGroup(Redshift $this, ClusterSubnetGroup group) {
        $this.deleteClusterSubnetGroup(new DeleteClusterSubnetGroupRequest().withClusterSubnetGroupName(group.name()));
    }

    public static void $init$(Redshift $this) {
    }
}

