/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack;

import com.github.seratch.jslack.http.SlackHttpClient;
import com.github.seratch.jslack.rtm.RTMClient;
import com.github.seratch.jslack.rtm.RTMStart;
import com.github.seratch.jslack.webhook.Payload;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Optional;
import okhttp3.Response;

public class Slack {
    private final Optional<String> apiToken;

    public Slack() {
        this.apiToken = Optional.empty();
    }

    public Slack(String apiToken) {
        this.apiToken = Optional.of(apiToken);
    }

    public Response send(String url, Payload payload) throws IOException {
        return new SlackHttpClient().postJsonPostRequest(url, payload);
    }

    public Optional<String> fetchWebSocketUrl() throws IOException {
        if (this.apiToken.isPresent()) {
            RTMStart start = new RTMStart();
            return start.fetchWebSocketUrl(this.apiToken.get());
        }
        throw new IllegalStateException("apiToken is absent. Use constructor which accepts apiToken.");
    }

    public RTMClient createRTMClient() throws IOException, URISyntaxException {
        Optional<String> wssUrl = this.fetchWebSocketUrl();
        if (wssUrl.isPresent()) {
            return new RTMClient(this.fetchWebSocketUrl().get());
        }
        throw new IllegalStateException("Couldn't fetch RTM API WebSocket endpoint. Ensure the apiToken value.");
    }
}

