/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.rtm;

import com.github.seratch.jslack.http.SlackHttpClient;
import com.github.seratch.jslack.json.GsonFactory;
import java.io.IOException;
import java.util.Optional;
import okhttp3.FormBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMStart {
    private static final Logger log = LoggerFactory.getLogger(RTMStart.class);
    public static final String ENDPOINT_URL = "https://slack.com/api/rtm.start";

    public Optional<String> fetchWebSocketUrl(String token) throws IOException {
        SlackHttpClient slackHttpClient = new SlackHttpClient();
        FormBody formBody = new FormBody.Builder().add("token", token).build();
        Response response = slackHttpClient.postForm(ENDPOINT_URL, formBody);
        String json = response.body().string();
        RTMStartResponse startResponse = (RTMStartResponse)GsonFactory.createSnakeCase().fromJson(json, RTMStartResponse.class);
        if (startResponse.isOk()) {
            return Optional.of(startResponse.getUrl());
        }
        log.warn("Failed to fetch RTM wss URL. response: {}", (Object)startResponse);
        return Optional.empty();
    }

    public static class RTMStartResponse {
        private boolean ok;
        private String url;

        public boolean isOk() {
            return this.ok;
        }

        public String getUrl() {
            return this.url;
        }

        public void setOk(boolean ok) {
            this.ok = ok;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RTMStartResponse)) {
                return false;
            }
            RTMStartResponse other = (RTMStartResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isOk() != other.isOk()) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RTMStartResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOk() ? 79 : 97);
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        public String toString() {
            return "RTMStart.RTMStartResponse(ok=" + this.isOk() + ", url=" + this.getUrl() + ")";
        }
    }
}

