/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack;

import com.github.seratch.jslack.api.methods.MethodsClient;
import com.github.seratch.jslack.api.methods.SlackApiException;
import com.github.seratch.jslack.api.methods.impl.MethodsClientImpl;
import com.github.seratch.jslack.api.methods.request.rtm.RTMStartRequest;
import com.github.seratch.jslack.api.rtm.RTMClient;
import com.github.seratch.jslack.api.webhook.Payload;
import com.github.seratch.jslack.common.http.SlackHttpClient;
import java.io.IOException;
import java.net.URISyntaxException;
import okhttp3.Response;

public class Slack {
    private static final Slack SINGLETON = new Slack();

    public static Slack getInstance() {
        return SINGLETON;
    }

    public Response send(String url, Payload payload) throws IOException {
        return new SlackHttpClient().postJsonPostRequest(url, payload);
    }

    public RTMClient rtm(String apiToken) throws IOException {
        try {
            return new RTMClient(this.methods().rtmStart(RTMStartRequest.builder().token(apiToken).build()).getUrl());
        }
        catch (SlackApiException | URISyntaxException e) {
            throw new IllegalStateException("Couldn't fetch RTM API WebSocket endpoint. Ensure the apiToken value.");
        }
    }

    public MethodsClient methods() {
        return new MethodsClientImpl();
    }
}

