/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.api.rtm;

import com.github.seratch.jslack.api.rtm.RTMMessageHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class RTMClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(RTMClient.class);
    private final URI wssUri;
    private Session currentSession = null;
    private final List<RTMMessageHandler> messageHandlers = new ArrayList<RTMMessageHandler>();

    public RTMClient(String wssUrl) throws URISyntaxException {
        if (wssUrl == null) {
            throw new IllegalArgumentException("The wss URL to start Real Time Messaging API is absent.");
        }
        this.wssUri = new URI(wssUrl);
    }

    public void connect() throws IOException, DeploymentException {
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        container.connectToServer((Object)this, this.wssUri);
        log.debug("client connected to the server: {}", (Object)this.wssUri);
    }

    public void disconnect() throws IOException {
        if (this.currentSession != null) {
            this.currentSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, RTMClient.class.getCanonicalName() + " did it"));
        }
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    @OnOpen
    public void onOpen(Session session) {
        log.debug("session opened: {}", (Object)session.getId());
        this.currentSession = session;
    }

    @OnClose
    public void onClose(Session session, CloseReason reason) {
        log.debug("session closed: {}, reason: {}", (Object)session.getId(), (Object)reason.getReasonPhrase());
        this.currentSession = null;
    }

    @OnMessage
    public void onMessage(String message) {
        log.debug("message: {}", (Object)message);
        this.messageHandlers.forEach(messageHandler -> messageHandler.handle(message));
    }

    public void addMessageHandler(RTMMessageHandler messageHandler) {
        this.messageHandlers.add(messageHandler);
    }

    public void removeMessageHandler(RTMMessageHandler messageHandler) {
        this.messageHandlers.remove(messageHandler);
    }

    public void sendMessage(String message) {
        this.currentSession.getAsyncRemote().sendText(message);
    }
}

