/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.api.methods;

import com.github.seratch.jslack.api.methods.SlackApiErrorResponse;
import com.github.seratch.jslack.common.json.GsonFactory;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackApiException
extends Exception {
    private static final Logger log = LoggerFactory.getLogger(SlackApiException.class);
    private final Response response;
    private final String responseBody;
    private final SlackApiErrorResponse error;

    public SlackApiException(Response response, String responseBody) {
        SlackApiErrorResponse parsedErrorResponse;
        block2: {
            this.response = response;
            this.responseBody = responseBody;
            parsedErrorResponse = null;
            try {
                parsedErrorResponse = (SlackApiErrorResponse)GsonFactory.createSnakeCase().fromJson(responseBody, SlackApiErrorResponse.class);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Failed to parse the error response body: {}", (Object)(responseBody.subSequence(0, 1000) + " ..."));
            }
        }
        this.error = parsedErrorResponse;
    }

    public Response getResponse() {
        return this.response;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public SlackApiErrorResponse getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlackApiException)) {
            return false;
        }
        SlackApiException other = (SlackApiException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Response this$response = this.getResponse();
        Response other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        String this$responseBody = this.getResponseBody();
        String other$responseBody = other.getResponseBody();
        if (this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody)) {
            return false;
        }
        SlackApiErrorResponse this$error = this.getError();
        SlackApiErrorResponse other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlackApiException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Response $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        String $responseBody = this.getResponseBody();
        result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        SlackApiErrorResponse $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SlackApiException(response=" + this.getResponse() + ", responseBody=" + this.getResponseBody() + ", error=" + this.getError() + ")";
    }
}

