/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.api.events;

import com.github.seratch.jslack.api.events.EventHandler;
import com.github.seratch.jslack.api.events.EventsDispatcher;
import com.github.seratch.jslack.api.events.payload.EventsApiPayload;
import com.github.seratch.jslack.common.json.GsonFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsDispatcherImpl
implements EventsDispatcher {
    private static final Logger log = LoggerFactory.getLogger(EventsDispatcherImpl.class);
    private final ConcurrentMap<String, List<EventHandler<?>>> eventTypeAndHandlers = new ConcurrentHashMap();
    private final Queue<String> queue = new LinkedList<String>();
    private final Thread eventLoopThread = new Thread(() -> {
        while (true) {
            String json;
            if ((json = this.queue.poll()) != null) {
                log.debug("New message found: {}", (Object)json);
                this.dispatch(json);
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    });

    @Override
    public void register(EventHandler<? extends EventsApiPayload<?>> handler) {
        String eventType = handler.getEventType();
        List handlers = this.eventTypeAndHandlers.getOrDefault(eventType, new ArrayList());
        handlers.add(handler);
        this.eventTypeAndHandlers.put(eventType, handlers);
    }

    @Override
    public void deregister(EventHandler<? extends EventsApiPayload<?>> handler) {
        String eventType = handler.getEventType();
        List handlers = this.eventTypeAndHandlers.getOrDefault(eventType, new ArrayList());
        ArrayList<EventHandler> newHandlers = new ArrayList<EventHandler>();
        for (EventHandler h : handlers) {
            if (h.equals(handler)) continue;
            newHandlers.add(h);
        }
        this.eventTypeAndHandlers.put(eventType, newHandlers);
    }

    @Override
    public void dispatch(String json) {
        String eventType = EventsDispatcherImpl.detectEventType(json);
        if (eventType == null) {
            log.debug("Failed to detect event type from the given JSON data: {}", (Object)json);
            return;
        }
        List eventHandlers = (List)this.eventTypeAndHandlers.get(eventType);
        if (eventHandlers == null || eventHandlers.size() == 0) {
            log.debug("No event handler registered for type: {}", (Object)eventType);
        } else {
            Class clazz = ((EventHandler)eventHandlers.get(0)).getEventPayloadClass();
            EventsApiPayload event = (EventsApiPayload)GsonFactory.createSnakeCase().fromJson(json, clazz);
            for (EventHandler handler : eventHandlers) {
                handler.acceptUntypedObject(event);
            }
        }
    }

    @Override
    public void enqueue(String json) {
        this.queue.add(json);
    }

    @Override
    public void start() {
        this.eventLoopThread.start();
    }

    @Override
    public void stop() {
        this.eventLoopThread.interrupt();
    }

    static String detectEventType(String json) {
        StringBuilder sb = new StringBuilder();
        char[] chars = json.toCharArray();
        boolean isInsideEventData = false;
        for (int idx = 0; idx < chars.length - 7; ++idx) {
            if (!isInsideEventData && chars[idx] == '\"' && chars[idx + 1] == 'e' && chars[idx + 2] == 'v' && chars[idx + 3] == 'e' && chars[idx + 4] == 'n' && chars[idx + 5] == 't' && chars[idx + 6] == '\"' && chars[idx + 7] == ':') {
                idx += 8;
                isInsideEventData = true;
            }
            if (!isInsideEventData || chars[idx] != '\"' || chars[idx + 1] != 't' || chars[idx + 2] != 'y' || chars[idx + 3] != 'p' || chars[idx + 4] != 'e' || chars[idx + 5] != '\"' || chars[idx + 6] != ':') continue;
            idx += 7;
            int doubleQuoteCount = 0;
            boolean isPreviousCharEscape = false;
            while (doubleQuoteCount < 2 && idx < chars.length) {
                char c = chars[idx];
                if (c == '\"' && !isPreviousCharEscape) {
                    ++doubleQuoteCount;
                } else if (doubleQuoteCount == 1) {
                    sb.append(c);
                }
                isPreviousCharEscape = c == '\\';
                ++idx;
            }
            break;
        }
        return sb.toString();
    }
}

