/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.api.rtm;

import com.github.seratch.jslack.api.model.event.Event;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class RTMEventHandler<E extends Event> {
    private String cachedEventName;
    private Class<E> cachedClazz;

    public String getEventType() {
        if (this.cachedEventName != null) {
            return this.cachedEventName;
        }
        Class<E> clazz = this.getEventClass();
        try {
            Field field = clazz.getField("TYPE_NAME");
            field.setAccessible(true);
            this.cachedEventName = (String)field.get(null);
            return this.cachedEventName;
        }
        catch (Exception e) {
            throw new IllegalStateException("A static field TYPE_NAME in " + clazz.getCanonicalName() + " is required");
        }
    }

    public Class<E> getEventClass() {
        if (this.cachedClazz != null) {
            return this.cachedClazz;
        }
        Type mySuperclass = this.getClass().getGenericSuperclass();
        Type tType = ((ParameterizedType)mySuperclass).getActualTypeArguments()[0];
        try {
            this.cachedClazz = Class.forName(tType.getTypeName());
            return this.cachedClazz;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load event class - " + e.getMessage());
        }
    }

    public abstract void handle(E var1);

    public void acceptUntypedObject(Object event) {
        this.handle((Event)event);
    }
}

