/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack;

import com.github.seratch.jslack.SlackConfig;
import com.github.seratch.jslack.api.methods.MethodsClient;
import com.github.seratch.jslack.api.methods.SlackApiException;
import com.github.seratch.jslack.api.methods.impl.MethodsClientImpl;
import com.github.seratch.jslack.api.methods.request.rtm.RTMConnectRequest;
import com.github.seratch.jslack.api.methods.request.rtm.RTMStartRequest;
import com.github.seratch.jslack.api.methods.request.users.UsersInfoRequest;
import com.github.seratch.jslack.api.methods.response.rtm.RTMConnectResponse;
import com.github.seratch.jslack.api.methods.response.rtm.RTMStartResponse;
import com.github.seratch.jslack.api.methods.response.users.UsersInfoResponse;
import com.github.seratch.jslack.api.model.User;
import com.github.seratch.jslack.api.rtm.RTMClient;
import com.github.seratch.jslack.api.scim.SCIMClient;
import com.github.seratch.jslack.api.scim.SCIMClientImpl;
import com.github.seratch.jslack.api.webhook.Payload;
import com.github.seratch.jslack.api.webhook.WebhookResponse;
import com.github.seratch.jslack.common.http.SlackHttpClient;
import com.github.seratch.jslack.shortcut.Shortcut;
import com.github.seratch.jslack.shortcut.impl.ShortcutImpl;
import com.github.seratch.jslack.shortcut.model.ApiToken;
import java.io.IOException;
import java.net.URISyntaxException;
import okhttp3.Response;

public class Slack {
    private static final Slack SINGLETON = new Slack(SlackConfig.DEFAULT, new SlackHttpClient());
    private final SlackHttpClient httpClient;
    private final SlackConfig config;

    public Slack() {
        this(SlackConfig.DEFAULT, new SlackHttpClient());
    }

    private Slack(SlackConfig config, SlackHttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
        this.httpClient.setConfig(config);
    }

    public static Slack getInstance() {
        return SINGLETON;
    }

    public static Slack getInstance(SlackConfig config) {
        return new Slack(config, new SlackHttpClient());
    }

    public static Slack getInstance(SlackConfig config, SlackHttpClient httpClient) {
        return new Slack(config, httpClient);
    }

    public static Slack getInstance(SlackHttpClient httpClient) {
        return new Slack(SlackConfig.DEFAULT, httpClient);
    }

    public SlackHttpClient getHttpClient() {
        return this.httpClient;
    }

    public WebhookResponse send(String url, Payload payload) throws IOException {
        Response httpResponse = this.getHttpClient().postJsonPostRequest(url, payload);
        String body = httpResponse.body().string();
        SlackHttpClient.debugLog(httpResponse, body, SlackConfig.DEFAULT);
        return WebhookResponse.builder().code(httpResponse.code()).message(httpResponse.message()).body(body).build();
    }

    public RTMClient rtm(String apiToken) throws IOException {
        return this.rtmConnect(apiToken);
    }

    public RTMClient rtmConnect(String apiToken) throws IOException {
        return this.rtmConnect(apiToken, true);
    }

    public RTMClient rtmConnect(String apiToken, boolean fullUserInfoRequired) throws IOException {
        try {
            RTMConnectResponse response = this.methods().rtmConnect(RTMConnectRequest.builder().token(apiToken).build());
            if (response.isOk()) {
                User connectedBotUser = response.getSelf();
                if (fullUserInfoRequired) {
                    String userId = response.getSelf().getId();
                    UsersInfoResponse resp = this.methods().usersInfo(UsersInfoRequest.builder().token(apiToken).user(userId).build());
                    if (resp.isOk()) {
                        connectedBotUser = resp.getUser();
                    } else {
                        String errorMessage = "Failed to get fill user info (user id: " + response.getSelf().getId() + ", error: " + resp.getError() + ")";
                        throw new IllegalStateException(errorMessage);
                    }
                }
                return new RTMClient(this, apiToken, response.getUrl(), connectedBotUser);
            }
            throw new IllegalStateException("Failed to the RTM endpoint URL (error: " + response.getError() + ")");
        }
        catch (SlackApiException e) {
            throw new IllegalStateException("Failed to connect to the RTM API endpoint. (status: " + e.getResponse().code() + ", error: " + e.getError().getError() + ")", e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to connect to the RTM API endpoint. (message: " + e.getMessage() + ")", e);
        }
    }

    public RTMClient rtmStart(String apiToken) throws IOException {
        return this.rtmStart(apiToken, true);
    }

    public RTMClient rtmStart(String apiToken, boolean fullUserInfoRequired) throws IOException {
        try {
            RTMStartResponse response = this.methods().rtmStart(RTMStartRequest.builder().token(apiToken).build());
            if (response.isOk()) {
                User connectedBotUser = response.getSelf();
                if (fullUserInfoRequired) {
                    String userId = response.getSelf().getId();
                    UsersInfoResponse resp = this.methods().usersInfo(UsersInfoRequest.builder().token(apiToken).user(userId).build());
                    if (resp.isOk()) {
                        connectedBotUser = resp.getUser();
                    } else {
                        String errorMessage = "Failed to get fill user info (user id: " + response.getSelf().getId() + ", error: " + resp.getError() + ")";
                        throw new IllegalStateException(errorMessage);
                    }
                }
                return new RTMClient(this, apiToken, response.getUrl(), connectedBotUser);
            }
            throw new IllegalStateException("Failed to the RTM endpoint URL (error: " + response.getError() + ")");
        }
        catch (SlackApiException e) {
            throw new IllegalStateException("Failed to connect to the RTM API endpoint. (status: " + e.getResponse().code() + ", error: " + e.getError().getError() + ")", e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to connect to the RTM API endpoint. (message: " + e.getMessage() + ")", e);
        }
    }

    public SCIMClient scim() {
        return new SCIMClientImpl(this.httpClient);
    }

    public MethodsClient methods() {
        return new MethodsClientImpl(this.httpClient);
    }

    public Shortcut shortcut() {
        return new ShortcutImpl(this);
    }

    public Shortcut shortcut(ApiToken apiToken) {
        return new ShortcutImpl(this, apiToken);
    }
}

