/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.common.http;

import com.github.seratch.jslack.SlackConfig;
import com.github.seratch.jslack.api.methods.SlackApiException;
import com.github.seratch.jslack.common.json.GsonFactory;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackHttpClient {
    private static final Logger log = LoggerFactory.getLogger(SlackHttpClient.class);
    private static final Logger JSON_RESPONSE_LOGGER = LoggerFactory.getLogger((String)"com.github.seratach.jslack.maintainer.json");
    private final OkHttpClient okHttpClient;
    private SlackConfig config = SlackConfig.DEFAULT;

    public SlackHttpClient() {
        this.okHttpClient = new OkHttpClient.Builder().build();
    }

    public SlackHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public SlackConfig getConfig() {
        return this.config;
    }

    public void setConfig(SlackConfig config) {
        this.config = config;
    }

    public Response postMultipart(String url, String token, MultipartBody multipartBody) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        Request request = new Request.Builder().url(url).header("Authorization", bearerHeaderValue).post((RequestBody)multipartBody).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postForm(String url, FormBody formBody) throws IOException {
        Request request = new Request.Builder().url(url).post((RequestBody)formBody).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postFormWithBearerHeader(String url, String token, FormBody formBody) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        Request request = new Request.Builder().url(url).header("Authorization", bearerHeaderValue).post((RequestBody)formBody).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postJsonPostRequest(String url, Object obj) throws IOException {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.toJsonString(obj));
        Request request = new Request.Builder().url(url).post(body).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response delete(Request.Builder requestBuilder) throws IOException {
        return this.okHttpClient.newCall(requestBuilder.method("DELETE", null).build()).execute();
    }

    private String toJsonString(Object obj) {
        Gson gson = GsonFactory.createSnakeCase();
        return gson.toJson(obj);
    }

    public static void debugLog(Response response, String body) throws IOException {
        SlackHttpClient.debugLog(response, body, SlackConfig.DEFAULT);
    }

    public static void debugLog(Response response, String body, SlackConfig config) throws IOException {
        if (log.isDebugEnabled()) {
            Buffer requestBody = new Buffer();
            response.request().body().writeTo((BufferedSink)requestBody);
            String textRequestBody = null;
            try {
                textRequestBody = requestBody.buffer().readUtf8();
            }
            catch (Exception e) {
                log.debug("Failed to read request body because {}, error: {}", (Object)e.getMessage(), (Object)e.getClass().getCanonicalName());
            }
            log.debug("\n[Request URL]\n{} {}\n[Specified Request Headers]\n{}[Request Body]\n{}\n\nContent-Type: {}\nContent Length: {}\n\n[Response Status]\n{} {}\n[Response Headers]\n{}[Response Body]\n{}\n", new Object[]{response.request().method(), response.request().url(), response.request().headers(), textRequestBody, response.request().body().contentType(), response.request().body().contentLength(), response.code(), response.message(), response.headers(), body});
            if (config.isPrettyResponseLoggingEnabled() && body != null && body.trim().startsWith("{")) {
                JsonParser parser = new JsonParser();
                JsonElement jsonObj = parser.parse(body);
                String prettifiedJson = GsonFactory.createSnakeCase(config).toJson(jsonObj);
                JSON_RESPONSE_LOGGER.debug("--- Pretty printing the response ---\n" + prettifiedJson + "\n-----------------------------------------");
            }
        }
    }

    public <T> T parseJsonResponse(Response response, Class<T> clazz) throws IOException, SlackApiException {
        if (response.code() == 200) {
            String body = response.body().string();
            SlackHttpClient.debugLog(response, body, this.config);
            return (T)GsonFactory.createSnakeCase(this.config).fromJson(body, clazz);
        }
        String body = response.body().string();
        throw new SlackApiException(response, body);
    }

    @Deprecated
    public static <T> T buildJsonResponse(Response response, Class<T> clazz) throws IOException, SlackApiException {
        if (response.code() == 200) {
            String body = response.body().string();
            SlackHttpClient.debugLog(response, body);
            return (T)GsonFactory.createSnakeCase().fromJson(body, clazz);
        }
        String body = response.body().string();
        throw new SlackApiException(response, body);
    }
}

