/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.common.json;

import com.github.seratch.jslack.api.model.block.ActionsBlock;
import com.github.seratch.jslack.api.model.block.ContextBlock;
import com.github.seratch.jslack.api.model.block.DividerBlock;
import com.github.seratch.jslack.api.model.block.ImageBlock;
import com.github.seratch.jslack.api.model.block.LayoutBlock;
import com.github.seratch.jslack.api.model.block.SectionBlock;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class GsonLayoutBlockFactory
implements JsonDeserializer<LayoutBlock>,
JsonSerializer<LayoutBlock> {
    public LayoutBlock deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonPrimitive prim = (JsonPrimitive)jsonObject.get("type");
        String className = prim.getAsString();
        Class<? extends LayoutBlock> clazz = this.getLayoutClassInstance(className);
        return (LayoutBlock)context.deserialize((JsonElement)jsonObject, clazz);
    }

    private Class<? extends LayoutBlock> getLayoutClassInstance(String className) {
        switch (className) {
            case "section": {
                return SectionBlock.class;
            }
            case "divider": {
                return DividerBlock.class;
            }
            case "image": {
                return ImageBlock.class;
            }
            case "context": {
                return ContextBlock.class;
            }
            case "actions": {
                return ActionsBlock.class;
            }
        }
        throw new JsonParseException("Unsupported layout block type: " + className);
    }

    public JsonElement serialize(LayoutBlock src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src);
    }
}

