/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.common.http.listener;

import com.github.seratch.jslack.common.http.listener.HttpResponseListener;
import java.io.IOException;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailedLoggingListener
extends HttpResponseListener {
    private static final Logger log = LoggerFactory.getLogger(DetailedLoggingListener.class);

    @Override
    public void accept(HttpResponseListener.State state) {
        if (log.isDebugEnabled()) {
            Response response = state.getResponse();
            String body = state.getParsedResponseBody();
            Buffer requestBody = new Buffer();
            try {
                response.request().body().writeTo((BufferedSink)requestBody);
            }
            catch (IOException e) {
                log.error("Failed to read the request body because {}", (Object)e.getMessage(), (Object)e);
            }
            String textRequestBody = null;
            try {
                textRequestBody = requestBody.buffer().readUtf8();
            }
            catch (Exception e) {
                log.debug("Failed to read request body because {}, error: {}", (Object)e.getMessage(), (Object)e.getClass().getCanonicalName());
            }
            Long contentLength = null;
            try {
                contentLength = response.request().body().contentLength();
            }
            catch (IOException e) {
                log.error("Failed to read the content length because {}", (Object)e.getMessage(), (Object)e);
            }
            log.debug("\n[Request URL]\n{} {}\n[Specified Request Headers]\n{}[Request Body]\n{}\n\nContent-Type: {}\nContent Length: {}\n\n[Response Status]\n{} {}\n[Response Headers]\n{}[Response Body]\n{}\n", new Object[]{response.request().method(), response.request().url(), response.request().headers(), textRequestBody, response.request().body().contentType(), contentLength, response.code(), response.message(), response.headers(), body});
        }
    }
}

