/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.app_backend;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackSignature {
    public static final String ALGORITHM = "HmacSHA256";

    private SlackSignature() {
    }

    public static class Generator {
        private static final Logger log = LoggerFactory.getLogger(Generator.class);
        private final String slackSigningSecret;

        public Generator() {
            this(System.getenv("SLACK_SIGNING_SECRET"));
        }

        public Generator(String slackSigningSecret) {
            this.slackSigningSecret = slackSigningSecret;
        }

        public String generate(String slackRequestTimestamp, String requestBody) {
            if (slackRequestTimestamp == null) {
                return null;
            }
            String baseString = "v0:" + slackRequestTimestamp + ":" + requestBody;
            SecretKeySpec sk = new SecretKeySpec(this.slackSigningSecret.getBytes(), SlackSignature.ALGORITHM);
            try {
                Mac mac = Mac.getInstance(SlackSignature.ALGORITHM);
                mac.init(sk);
                byte[] macBytes = mac.doFinal(baseString.getBytes());
                StringBuilder hashValue = new StringBuilder(2 * macBytes.length);
                for (byte macByte : macBytes) {
                    hashValue.append(String.format("%02x", macByte & 0xFF));
                }
                return "v0=" + hashValue.toString();
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                log.error("Failed to hash the base string value with HMAC-SHA256 because {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
    }

    public static class Secret {
        public static final String DEFAULT_ENV_NAME = "SLACK_SIGNING_SECRET";

        private Secret() {
        }
    }

    public static class HeaderNames {
        public static final String X_SLACK_REQUEST_TIMESTAMP = "X-Slack-Request-Timestamp";
        public static final String X_SLACK_SIGNATURE = "X-Slack-Signature";

        private HeaderNames() {
        }
    }
}

