/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.common.http;

import com.github.seratch.jslack.SlackConfig;
import com.github.seratch.jslack.api.methods.SlackApiException;
import com.github.seratch.jslack.common.http.listener.DetailedLoggingListener;
import com.github.seratch.jslack.common.http.listener.HttpResponseListener;
import com.github.seratch.jslack.common.json.GsonFactory;
import com.google.gson.Gson;
import java.io.IOException;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackHttpClient {
    private static final Logger log = LoggerFactory.getLogger(SlackHttpClient.class);
    private final OkHttpClient okHttpClient;
    private SlackConfig config = SlackConfig.DEFAULT;
    private static final DetailedLoggingListener DETAILED_LOGGER = new DetailedLoggingListener();

    public SlackHttpClient() {
        this.okHttpClient = new OkHttpClient.Builder().build();
    }

    public SlackHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public SlackConfig getConfig() {
        return this.config;
    }

    public void setConfig(SlackConfig config) {
        this.config = config;
    }

    public Response postMultipart(String url, String token, MultipartBody multipartBody) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        Request request = new Request.Builder().url(url).header("Authorization", bearerHeaderValue).post((RequestBody)multipartBody).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postForm(String url, FormBody formBody) throws IOException {
        Request request = new Request.Builder().url(url).post((RequestBody)formBody).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postFormWithBearerHeader(String url, String token, FormBody formBody) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        Request request = new Request.Builder().url(url).header("Authorization", bearerHeaderValue).post((RequestBody)formBody).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postJsonPostRequest(String url, Object obj) throws IOException {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.toJsonString(obj));
        Request request = new Request.Builder().url(url).post(body).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response delete(Request.Builder requestBuilder) throws IOException {
        return this.okHttpClient.newCall(requestBuilder.method("DELETE", null).build()).execute();
    }

    private String toJsonString(Object obj) {
        Gson gson = GsonFactory.createSnakeCase();
        return gson.toJson(obj);
    }

    public void runHttpResponseListeners(Response response, String body) {
        HttpResponseListener.State state = new HttpResponseListener.State(this.config, response, body);
        for (HttpResponseListener responseListener : this.config.getHttpClientResponseHandlers()) {
            responseListener.accept(state);
        }
    }

    public <T> T parseJsonResponse(Response response, Class<T> clazz) throws IOException, SlackApiException {
        if (response.code() == 200) {
            String body = response.body().string();
            this.runHttpResponseListeners(response, body);
            return (T)GsonFactory.createSnakeCase(this.config).fromJson(body, clazz);
        }
        String body = response.body().string();
        throw new SlackApiException(response, body);
    }

    @Deprecated
    public static <T> T buildJsonResponse(Response response, Class<T> clazz) throws IOException, SlackApiException {
        if (response.code() == 200) {
            String body = response.body().string();
            DETAILED_LOGGER.accept(new HttpResponseListener.State(SlackConfig.DEFAULT, response, body));
            return (T)GsonFactory.createSnakeCase().fromJson(body, clazz);
        }
        String body = response.body().string();
        throw new SlackApiException(response, body);
    }
}

