/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack;

import com.github.seratch.jslack.common.http.listener.DetailedLoggingListener;
import com.github.seratch.jslack.common.http.listener.HttpResponseListener;
import com.github.seratch.jslack.common.http.listener.ResponsePrettyPrintingListener;
import java.util.ArrayList;
import java.util.List;

public class SlackConfig {
    public static final SlackConfig DEFAULT = new SlackConfig(){

        @Override
        public void setPrettyResponseLoggingEnabled(boolean prettyResponseLoggingEnabled) {
            throw new UnsupportedOperationException("This config is immutable");
        }

        @Override
        public void setLibraryMaintainerMode(boolean libraryMaintainerMode) {
            throw new UnsupportedOperationException("This config is immutable");
        }
    };
    private boolean prettyResponseLoggingEnabled = false;
    private boolean libraryMaintainerMode = false;
    private List<HttpResponseListener> httpClientResponseHandlers = new ArrayList<HttpResponseListener>();

    public SlackConfig() {
        this.getHttpClientResponseHandlers().add(new DetailedLoggingListener());
        this.getHttpClientResponseHandlers().add(new ResponsePrettyPrintingListener());
    }

    public boolean isPrettyResponseLoggingEnabled() {
        return this.prettyResponseLoggingEnabled;
    }

    public boolean isLibraryMaintainerMode() {
        return this.libraryMaintainerMode;
    }

    public List<HttpResponseListener> getHttpClientResponseHandlers() {
        return this.httpClientResponseHandlers;
    }

    public void setPrettyResponseLoggingEnabled(boolean prettyResponseLoggingEnabled) {
        this.prettyResponseLoggingEnabled = prettyResponseLoggingEnabled;
    }

    public void setLibraryMaintainerMode(boolean libraryMaintainerMode) {
        this.libraryMaintainerMode = libraryMaintainerMode;
    }

    public void setHttpClientResponseHandlers(List<HttpResponseListener> httpClientResponseHandlers) {
        this.httpClientResponseHandlers = httpClientResponseHandlers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlackConfig)) {
            return false;
        }
        SlackConfig other = (SlackConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPrettyResponseLoggingEnabled() != other.isPrettyResponseLoggingEnabled()) {
            return false;
        }
        if (this.isLibraryMaintainerMode() != other.isLibraryMaintainerMode()) {
            return false;
        }
        List<HttpResponseListener> this$httpClientResponseHandlers = this.getHttpClientResponseHandlers();
        List<HttpResponseListener> other$httpClientResponseHandlers = other.getHttpClientResponseHandlers();
        return !(this$httpClientResponseHandlers == null ? other$httpClientResponseHandlers != null : !((Object)this$httpClientResponseHandlers).equals(other$httpClientResponseHandlers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlackConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrettyResponseLoggingEnabled() ? 79 : 97);
        result = result * 59 + (this.isLibraryMaintainerMode() ? 79 : 97);
        List<HttpResponseListener> $httpClientResponseHandlers = this.getHttpClientResponseHandlers();
        result = result * 59 + ($httpClientResponseHandlers == null ? 43 : ((Object)$httpClientResponseHandlers).hashCode());
        return result;
    }

    public String toString() {
        return "SlackConfig(prettyResponseLoggingEnabled=" + this.isPrettyResponseLoggingEnabled() + ", libraryMaintainerMode=" + this.isLibraryMaintainerMode() + ", httpClientResponseHandlers=" + this.getHttpClientResponseHandlers() + ")";
    }
}

